/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.io.writer.impl.DirectMemoryManager;
import org.apache.pinot.segment.local.utils.nativefst.ByteSequenceIterator;
import org.apache.pinot.segment.local.utils.nativefst.FSTFlags;
import org.apache.pinot.segment.local.utils.nativefst.FSTHeader;
import org.apache.pinot.segment.local.utils.nativefst.ImmutableFST;
import org.apache.pinot.segment.local.utils.nativefst.StateVisitor;
import org.apache.pinot.segment.local.utils.nativefst.builder.FSTSerializerImpl;

public abstract class FST
implements Iterable<ByteBuffer> {
    protected static byte[] readRemaining(InputStream in, int length) throws IOException {
        byte[] buf = new byte[length];
        int readLen = in.read(buf, 0, length);
        if (readLen == -1) {
            return null;
        }
        return buf;
    }

    public static FST read(InputStream stream) throws IOException {
        return FST.read(stream, false, new DirectMemoryManager(FST.class.getName()));
    }

    public static FST read(InputStream stream, boolean hasOutputSymbols, PinotDataBufferMemoryManager memoryManager) throws IOException {
        FSTHeader header = FSTHeader.read(stream);
        switch (header._version) {
            case 5: {
                return new ImmutableFST(stream, hasOutputSymbols, memoryManager);
            }
        }
        throw new IOException(String.format(Locale.ROOT, "Unsupported automaton version: 0x%02x", header._version & 0xFF));
    }

    public static <T extends FST> T read(InputStream stream, Class<? extends T> clazz, boolean hasOutputSymbols) throws IOException {
        FST fst = FST.read(stream, hasOutputSymbols, new DirectMemoryManager(FST.class.getName()));
        if (!clazz.isInstance(fst)) {
            throw new IOException(String.format(Locale.ROOT, "Expected FST type %s, but read an incompatible type %s.", clazz.getName(), fst.getClass().getName()));
        }
        return (T)((FST)clazz.cast(fst));
    }

    public static String printToString(FST fst) {
        StringBuilder b = new StringBuilder();
        b.append("initial state: ").append(fst.getRootNode()).append("\n");
        fst.visitInPreOrder(state -> {
            b.append("state : " + state).append("\n");
            int arc = fst.getFirstArc(state);
            while (arc != 0) {
                b.append(" { arc: " + arc + " targetNode: " + (fst.isArcFinal(arc) ? "final arc" : Integer.valueOf(fst.getEndNode(arc))) + " label: " + (char)fst.getArcLabel(arc) + " }");
                arc = fst.getNextArc(arc);
            }
            b.append("\n");
            return true;
        });
        return b.toString();
    }

    public abstract int getRootNode();

    public abstract int getFirstArc(int var1);

    public abstract int getNextArc(int var1);

    public abstract int getArc(int var1, byte var2);

    public abstract byte getArcLabel(int var1);

    public abstract int getOutputSymbol(int var1);

    public abstract boolean isArcFinal(int var1);

    public abstract boolean isArcTerminal(int var1);

    public abstract int getEndNode(int var1);

    public abstract Set<FSTFlags> getFlags();

    public int getRightLanguageCount(int node) {
        throw new UnsupportedOperationException("Automaton not compiled with " + (Object)((Object)FSTFlags.NUMBERS));
    }

    public Iterable<ByteBuffer> getSequences(int node) {
        if (node == 0) {
            return Collections.emptyList();
        }
        return () -> new ByteSequenceIterator(this, node);
    }

    public final Iterable<ByteBuffer> getSequences() {
        return this.getSequences(this.getRootNode());
    }

    @Override
    public final Iterator<ByteBuffer> iterator() {
        return this.getSequences().iterator();
    }

    public <T extends StateVisitor> T visitInPostOrder(T v) {
        return this.visitInPostOrder(v, this.getRootNode());
    }

    public <T extends StateVisitor> T visitInPostOrder(T v, int node) {
        this.visitInPostOrder(v, node, new BitSet());
        return v;
    }

    private boolean visitInPostOrder(StateVisitor v, int node, BitSet visited) {
        if (visited.get(node)) {
            return true;
        }
        visited.set(node);
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (!this.isArcTerminal(arc) && !this.visitInPostOrder(v, this.getEndNode(arc), visited)) {
                return false;
            }
            arc = this.getNextArc(arc);
        }
        return v.accept(node);
    }

    public <T extends StateVisitor> T visitInPreOrder(T v) {
        return this.visitInPreOrder(v, this.getRootNode());
    }

    public <T extends StateVisitor> T visitInPreOrder(T v, int node) {
        this.visitInPreOrder(v, node, new BitSet());
        return v;
    }

    protected Map<Integer, Integer> buildMap(String inputString) {
        String[] pairs;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if ((inputString = inputString.substring(1, inputString.length() - 1)).isEmpty()) {
            return hashMap;
        }
        for (String pair : pairs = inputString.split(",")) {
            String[] keyVal = pair.split("=");
            int key = Integer.parseInt(keyVal[0].trim());
            int val = Integer.parseInt(keyVal[1].trim());
            hashMap.put(key, val);
        }
        return hashMap;
    }

    public abstract boolean isArcLast(int var1);

    public void save(FileOutputStream fileOutputStream) {
        try {
            byte[] fsaData = new FSTSerializerImpl().withNumbers().serialize(this, new ByteArrayOutputStream()).toByteArray();
            fileOutputStream.write(fsaData);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void visitInPreOrder(StateVisitor v, int node, BitSet visited) {
        if (visited.get(node)) {
            return;
        }
        visited.set(node);
        if (v.accept(node)) {
            int arc = this.getFirstArc(node);
            while (arc != 0) {
                if (!this.isArcTerminal(arc)) {
                    this.visitInPreOrder(v, this.getEndNode(arc), visited);
                }
                arc = this.getNextArc(arc);
            }
        }
    }

    public String toString() {
        return FST.printToString(this);
    }
}

