/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.automaton.BasicOperations;
import org.apache.pinot.segment.local.utils.nativefst.automaton.MinimizationOperations;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.StatePair;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;

public class Automaton
implements Serializable,
Cloneable {
    public static final int MINIMIZE_HUFFMAN = 0;
    public static final int MINIMIZE_BRZOZOWSKI = 1;
    public static final int MINIMIZE_HOPCROFT = 2;
    public static final int MINIMIZE_VALMARI = 3;
    public static boolean _minimizeAlways = false;
    public static boolean _allowMutation = false;
    public static int _minimization = 2;
    State _initial = new State();
    boolean _deterministic = true;
    int _hashCode;
    String _singleton = null;

    public static boolean setAllowMutate(boolean flag) {
        boolean b = _allowMutation;
        _allowMutation = flag;
        return b;
    }

    static void setStateNumbers(Set<State> states) {
        if (states.size() == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("number of states exceeded Integer.MAX_VALUE");
        }
        int number = 0;
        for (State s : states) {
            s._number = number++;
        }
    }

    static Transition[][] getSortedTransitions(Set<State> states) {
        Automaton.setStateNumbers(states);
        Transition[][] transitions = new Transition[states.size()][];
        for (State s : states) {
            transitions[s._number] = s.getSortedTransitionArray(false);
        }
        return transitions;
    }

    public static Automaton minimize(Automaton a) {
        a.minimize();
        return a;
    }

    void checkMinimizeAlways() {
        if (_minimizeAlways) {
            this.minimize();
        }
    }

    boolean isSingleton() {
        return this._singleton != null;
    }

    public State getInitialState() {
        this.expandSingleton();
        return this._initial;
    }

    public void setInitialState(State s) {
        this._initial = s;
        this._singleton = null;
    }

    public Set<State> getStates() {
        this.expandSingleton();
        HashSet<State> visited = new HashSet<State>();
        LinkedList<State> worklist = new LinkedList<State>();
        worklist.add(this._initial);
        visited.add(this._initial);
        while (!worklist.isEmpty()) {
            State s = (State)worklist.removeFirst();
            Set<Transition> tr = s._transitionSet;
            for (Transition t : tr) {
                if (visited.contains(t._to)) continue;
                visited.add(t._to);
                worklist.add(t._to);
            }
        }
        return visited;
    }

    public Set<State> getAcceptStates() {
        this.expandSingleton();
        HashSet<State> accepts = new HashSet<State>();
        HashSet<State> visited = new HashSet<State>();
        LinkedList<State> worklist = new LinkedList<State>();
        worklist.add(this._initial);
        visited.add(this._initial);
        while (!worklist.isEmpty()) {
            State s = (State)worklist.removeFirst();
            if (s._accept) {
                accepts.add(s);
            }
            Set<Transition> tr = s._transitionSet;
            for (Transition t : tr) {
                if (visited.contains(t._to)) continue;
                visited.add(t._to);
                worklist.add(t._to);
            }
        }
        return accepts;
    }

    void totalize() {
        State s = new State();
        s._transitionSet.add(new Transition('\u0000', '\uffff', s));
        for (State p : this.getStates()) {
            int maxi = 0;
            for (Transition t : p.getSortedTransitions(false)) {
                if (t._min > maxi) {
                    p._transitionSet.add(new Transition((char)maxi, (char)(t._min - '\u0001'), s));
                }
                if (t._max + '\u0001' <= maxi) continue;
                maxi = t._max + '\u0001';
            }
            if (maxi > 65535) continue;
            p._transitionSet.add(new Transition((char)maxi, '\uffff', s));
        }
    }

    public void reduce() {
        if (this.isSingleton()) {
            return;
        }
        Set<State> states = this.getStates();
        Automaton.setStateNumbers(states);
        for (State s : states) {
            List<Transition> st = s.getSortedTransitions(true);
            s.resetTransitions();
            State p = null;
            int min = -1;
            char c = '\uffffffff';
            for (Transition t : st) {
                if (p == t._to) {
                    if (t._min <= c + 1) {
                        if (t._max <= c) continue;
                        c = t._max;
                        continue;
                    }
                    if (p != null) {
                        s._transitionSet.add(new Transition((char)min, c, p));
                    }
                    min = t._min;
                    c = t._max;
                    continue;
                }
                if (p != null) {
                    s._transitionSet.add(new Transition((char)min, c, p));
                }
                p = t._to;
                min = t._min;
                c = t._max;
            }
            if (p == null) continue;
            s._transitionSet.add(new Transition((char)min, c, p));
        }
        this.clearHashCode();
    }

    char[] getStartPoints() {
        HashSet<Character> pointset = new HashSet<Character>();
        pointset.add(Character.valueOf('\u0000'));
        for (State s : this.getStates()) {
            for (Transition t : s._transitionSet) {
                pointset.add(Character.valueOf(t._min));
                if (t._max >= '\uffff') continue;
                pointset.add(Character.valueOf((char)(t._max + '\u0001')));
            }
        }
        char[] points = new char[pointset.size()];
        int n = 0;
        for (Character m : pointset) {
            points[n++] = m.charValue();
        }
        Arrays.sort(points);
        return points;
    }

    private Set<State> getLiveStates(Set<State> states) {
        HashMap map = new HashMap();
        for (State s : states) {
            map.put(s, new HashSet());
        }
        for (State s : states) {
            for (Transition t : s._transitionSet) {
                ((Set)map.get(t._to)).add(s);
            }
        }
        HashSet<State> live = new HashSet<State>(this.getAcceptStates());
        LinkedList<State> worklist = new LinkedList<State>(live);
        while (!worklist.isEmpty()) {
            State s = worklist.removeFirst();
            for (State p : (Set)map.get(s)) {
                if (live.contains(p)) continue;
                live.add(p);
                worklist.add(p);
            }
        }
        return live;
    }

    public void removeDeadTransitions() {
        this.clearHashCode();
        if (this.isSingleton()) {
            return;
        }
        Set<State> states = this.getStates();
        Set<State> live = this.getLiveStates(states);
        for (State s : states) {
            Set<Transition> st = s._transitionSet;
            s.resetTransitions();
            for (Transition t : st) {
                if (!live.contains(t._to)) continue;
                s._transitionSet.add(t);
            }
        }
        this.reduce();
    }

    public void expandSingleton() {
        if (this.isSingleton()) {
            State p;
            this._initial = p = new State();
            for (int i = 0; i < this._singleton.length(); ++i) {
                State q = new State();
                q._number = i;
                p._transitionSet.add(new Transition(this._singleton.charAt(i), q));
                p = q;
            }
            p._accept = true;
            this._deterministic = true;
            this._singleton = null;
        }
    }

    public int getNumberOfStates() {
        if (this.isSingleton()) {
            return this._singleton.length() + 1;
        }
        return this.getStates().size();
    }

    public int getNumberOfTransitions() {
        if (this.isSingleton()) {
            return this._singleton.length();
        }
        int c = 0;
        for (State s : this.getStates()) {
            c += s._transitionSet.size();
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Automaton)) {
            return false;
        }
        Automaton a = (Automaton)obj;
        if (this.isSingleton() && a.isSingleton()) {
            return this._singleton.equals(a._singleton);
        }
        return this.hashCode() == a.hashCode() && this.subsetOf(a) && a.subsetOf(this);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this.minimize();
        }
        return this._hashCode;
    }

    void recomputeHashCode() {
        this._hashCode = this.getNumberOfStates() * 3 + this.getNumberOfTransitions() * 2;
        if (this._hashCode == 0) {
            this._hashCode = 1;
        }
    }

    void clearHashCode() {
        this._hashCode = 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isSingleton()) {
            b.append("singleton: ");
            for (char c : this._singleton.toCharArray()) {
                Transition.appendCharString(c, b);
            }
            b.append("\n");
        } else {
            Set<State> states = this.getStates();
            Automaton.setStateNumbers(states);
            b.append("initial state: ").append(this._initial._number).append("\n");
            for (State s : states) {
                b.append(s.toString());
            }
        }
        return b.toString();
    }

    Automaton cloneExpanded() {
        Automaton a = this.clone();
        a.expandSingleton();
        return a;
    }

    Automaton cloneExpandedIfRequired() {
        if (_allowMutation) {
            this.expandSingleton();
            return this;
        }
        return this.cloneExpanded();
    }

    public Automaton clone() {
        try {
            Automaton a = (Automaton)super.clone();
            if (!this.isSingleton()) {
                HashMap<State, State> m = new HashMap<State, State>();
                Set<State> states = this.getStates();
                for (State s : states) {
                    m.put(s, new State());
                }
                for (State s : states) {
                    State p = (State)m.get(s);
                    p._accept = s._accept;
                    if (s == this._initial) {
                        a._initial = p;
                    }
                    for (Transition t : s._transitionSet) {
                        p._transitionSet.add(new Transition(t._min, t._max, (State)m.get(t._to)));
                    }
                }
            }
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    Automaton cloneIfRequired() {
        if (_allowMutation) {
            return this;
        }
        return this.clone();
    }

    public Automaton optional() {
        return BasicOperations.optional(this);
    }

    public Automaton repeat() {
        return BasicOperations.repeat(this);
    }

    public Automaton repeat(int min) {
        return BasicOperations.repeat(this, min);
    }

    public Automaton repeat(int min, int max) {
        return BasicOperations.repeat(this, min, max);
    }

    public Automaton complement() {
        return BasicOperations.complement(this);
    }

    public Automaton minus(Automaton a) {
        return BasicOperations.minus(this, a);
    }

    public Automaton intersection(Automaton a) {
        return BasicOperations.intersection(this, a);
    }

    public boolean subsetOf(Automaton a) {
        return BasicOperations.subsetOf(this, a);
    }

    public void determinize() {
        BasicOperations.determinize(this);
    }

    public void addEpsilons(Collection<StatePair> pairs) {
        BasicOperations.addEpsilons(this, pairs);
    }

    public boolean isEmptyString() {
        return BasicOperations.isEmptyString(this);
    }

    public boolean isEmpty() {
        return BasicOperations.isEmpty(this);
    }

    public boolean run(String s) {
        return BasicOperations.run(this, s);
    }

    public void minimize() {
        MinimizationOperations.minimize(this);
    }
}

