/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.cglib.proxy;

import org.skife.jdbi.asm.Type;
import org.skife.jdbi.cglib.proxy.Callback;
import org.skife.jdbi.cglib.proxy.CallbackGenerator;
import org.skife.jdbi.cglib.proxy.Dispatcher;
import org.skife.jdbi.cglib.proxy.DispatcherGenerator;
import org.skife.jdbi.cglib.proxy.FixedValue;
import org.skife.jdbi.cglib.proxy.FixedValueGenerator;
import org.skife.jdbi.cglib.proxy.InvocationHandler;
import org.skife.jdbi.cglib.proxy.InvocationHandlerGenerator;
import org.skife.jdbi.cglib.proxy.LazyLoader;
import org.skife.jdbi.cglib.proxy.LazyLoaderGenerator;
import org.skife.jdbi.cglib.proxy.MethodInterceptor;
import org.skife.jdbi.cglib.proxy.MethodInterceptorGenerator;
import org.skife.jdbi.cglib.proxy.NoOp;
import org.skife.jdbi.cglib.proxy.NoOpGenerator;
import org.skife.jdbi.cglib.proxy.ProxyRefDispatcher;

class CallbackInfo {
    private Class cls;
    private CallbackGenerator generator;
    private Type type;
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};

    public static Type[] determineTypes(Class[] callbackTypes) {
        return CallbackInfo.determineTypes(callbackTypes, true);
    }

    public static Type[] determineTypes(Class[] callbackTypes, boolean checkAll) {
        Type[] types = new Type[callbackTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = CallbackInfo.determineType(callbackTypes[i], checkAll);
        }
        return types;
    }

    public static Type[] determineTypes(Callback[] callbacks) {
        return CallbackInfo.determineTypes(callbacks, true);
    }

    public static Type[] determineTypes(Callback[] callbacks, boolean checkAll) {
        Type[] types = new Type[callbacks.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = CallbackInfo.determineType(callbacks[i], checkAll);
        }
        return types;
    }

    public static CallbackGenerator[] getGenerators(Type[] callbackTypes) {
        CallbackGenerator[] generators = new CallbackGenerator[callbackTypes.length];
        for (int i = 0; i < generators.length; ++i) {
            generators[i] = CallbackInfo.getGenerator(callbackTypes[i]);
        }
        return generators;
    }

    private CallbackInfo(Class cls, CallbackGenerator generator) {
        this.cls = cls;
        this.generator = generator;
        this.type = Type.getType(cls);
    }

    private static Type determineType(Callback callback, boolean checkAll) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass(), checkAll);
    }

    private static Type determineType(Class callbackType, boolean checkAll) {
        Class cur = null;
        Type type = null;
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo info = CALLBACKS[i];
            if (!info.cls.isAssignableFrom(callbackType)) continue;
            if (cur != null) {
                String string = String.valueOf(cur);
                String string2 = String.valueOf(info.cls);
                throw new IllegalStateException(new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Callback implements both ").append(string).append(" and ").append(string2).toString());
            }
            cur = info.cls;
            type = info.type;
            if (!checkAll) break;
        }
        if (cur == null) {
            String string = String.valueOf(callbackType);
            throw new IllegalStateException(new StringBuilder(22 + String.valueOf(string).length()).append("Unknown callback type ").append(string).toString());
        }
        return type;
    }

    private static CallbackGenerator getGenerator(Type callbackType) {
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo info = CALLBACKS[i];
            if (!info.type.equals(callbackType)) continue;
            return info.generator;
        }
        String string = String.valueOf(callbackType);
        throw new IllegalStateException(new StringBuilder(22 + String.valueOf(string).length()).append("Unknown callback type ").append(string).toString());
    }
}

