/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.NamedArgumentFinder;

public class Binding {
    private Map<Integer, Argument> positionals = new HashMap<Integer, Argument>();
    private Map<String, Argument> named = new HashMap<String, Argument>();
    private List<NamedArgumentFinder> namedArgumentFinder = new ArrayList<NamedArgumentFinder>();

    void addPositional(int position, Argument parameter) {
        this.positionals.put(position, parameter);
    }

    public Argument forName(String name) {
        if (this.named.containsKey(name)) {
            return this.named.get(name);
        }
        for (NamedArgumentFinder arguments : this.namedArgumentFinder) {
            Argument arg = arguments.find(name);
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public Argument forPosition(int position) {
        return this.positionals.get(position);
    }

    void addNamed(String name, Argument argument) {
        this.named.put(name, argument);
    }

    void addNamedArgumentFinder(NamedArgumentFinder args) {
        this.namedArgumentFinder.add(args);
    }

    public String toString() {
        boolean wrote = false;
        StringBuilder b = new StringBuilder();
        b.append("{ positional:{");
        for (Map.Entry<Integer, Argument> entry : this.positionals.entrySet()) {
            wrote = true;
            b.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
        }
        if (wrote) {
            wrote = false;
            b.deleteCharAt(b.length() - 1);
        }
        b.append("}");
        b.append(", named:{");
        for (Map.Entry<Object, Argument> entry : this.named.entrySet()) {
            wrote = true;
            b.append((String)entry.getKey()).append(":").append(entry.getValue()).append(",");
        }
        if (wrote) {
            wrote = false;
            b.deleteCharAt(b.length() - 1);
        }
        b.append("}");
        b.append(", finder:[");
        for (NamedArgumentFinder namedArgumentFinder : this.namedArgumentFinder) {
            wrote = true;
            b.append(namedArgumentFinder).append(",");
        }
        if (wrote) {
            b.deleteCharAt(b.length() - 1);
        }
        b.append("]");
        b.append("}");
        return b.toString();
    }

    public void clear() {
        this.positionals.clear();
        this.named.clear();
        this.namedArgumentFinder.clear();
    }
}

