/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.RewrittenStatement;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class NoOpStatementRewriter
implements StatementRewriter {
    @Override
    public RewrittenStatement rewrite(String sql, Binding params, StatementContext ctx) {
        return new NoOpRewrittenStatement(sql, ctx);
    }

    private static class NoOpRewrittenStatement
    implements RewrittenStatement {
        private final String sql;
        private final StatementContext context;

        NoOpRewrittenStatement(String sql, StatementContext ctx) {
            this.context = ctx;
            this.sql = sql;
        }

        @Override
        public void bind(Binding params, PreparedStatement statement) throws SQLException {
            Argument s;
            int i = 0;
            while ((s = params.forPosition(i)) != null) {
                s.apply(i + 1, statement, this.context);
                ++i;
            }
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }
}

