/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum FloatColumnMapper implements ResultColumnMapper<Float>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private FloatColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Float mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        float value = r.getFloat(columnNumber);
        return this.nullable && r.wasNull() ? null : Float.valueOf(value);
    }

    @Override
    public Float mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        float value = r.getFloat(columnLabel);
        return this.nullable && r.wasNull() ? null : Float.valueOf(value);
    }
}

