/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class DeserializationHelper {
    private static final String ENTITY_EXPANSION_EXCEPTION_MESSAGE = "(.|\n)*Message: JAXP00010001: The parser has encountered more than \"\\d+\" entity expansions in this document; this is the limit imposed by the JDK\\.";
    private static XMLInputFactory xmlif;

    public static void setupXMLInputFactory() {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        DeserializationHelper.xmlif = xmlif;
    }

    public static boolean isEntityExpansionLimitException(XMLStreamException e) {
        return e.getMessage() != null && e.getMessage().matches(ENTITY_EXPANSION_EXCEPTION_MESSAGE);
    }

    public static XMLStreamReader createXMLStreamReaderFromReader(Reader reader) throws XMLStreamException {
        while (true) {
            try {
                return xmlif.createXMLStreamReader(reader);
            }
            catch (XMLStreamException e) {
                if (DeserializationHelper.isEntityExpansionLimitException(e)) {
                    DeserializationHelper.setupXMLInputFactory();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static XMLStreamReader createXMLStreamReaderFromStream(InputStream streamRef) throws XMLStreamException {
        while (true) {
            try {
                return xmlif.createXMLStreamReader(streamRef, "UTF-8");
            }
            catch (XMLStreamException e) {
                if (DeserializationHelper.isEntityExpansionLimitException(e)) {
                    DeserializationHelper.setupXMLInputFactory();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static String readElementFromXMLReader(XMLStreamReader xmlr, String elementName) throws XMLStreamException {
        return DeserializationHelper.readElementFromXMLReader(xmlr, elementName, true);
    }

    public static String readElementFromXMLReader(XMLStreamReader xmlr, String elementName, boolean returnNullOnEmpty) throws XMLStreamException {
        xmlr.require(1, null, elementName);
        int eventType = xmlr.next();
        StringBuilder retVal = new StringBuilder();
        if (eventType == 4) {
            do {
                retVal.append(xmlr.getText());
            } while ((eventType = xmlr.next()) == 4);
        }
        xmlr.require(2, null, elementName);
        if (retVal.length() == 0) {
            return returnNullOnEmpty ? null : "";
        }
        return retVal.toString();
    }

    private DeserializationHelper() {
    }

    static {
        DeserializationHelper.setupXMLInputFactory();
    }
}

