/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.mysql;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class MySqlConfig {
    private boolean autoReconnect = true;
    private int maxReconnects = 3;
    private Duration connectionTimeout = new Duration(10.0, TimeUnit.SECONDS);

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Config(value="mysql.auto-reconnect")
    public MySqlConfig setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxReconnects() {
        return this.maxReconnects;
    }

    @Config(value="mysql.max-reconnects")
    public MySqlConfig setMaxReconnects(int maxReconnects) {
        this.maxReconnects = maxReconnects;
        return this;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="mysql.connection-timeout")
    public MySqlConfig setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }
}

