/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.FixedSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.NormalizedDateSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SimpleSegmentNameGenerator;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.IngestionConfigUtils;

public class SegmentNameGeneratorFactory {
    public static final String FIXED_SEGMENT_NAME_GENERATOR = "fixed";
    public static final String SIMPLE_SEGMENT_NAME_GENERATOR = "simple";
    public static final String NORMALIZED_DATE_SEGMENT_NAME_GENERATOR = "normalizeddate";

    private SegmentNameGeneratorFactory() {
    }

    public static SegmentNameGenerator createSegmentNameGenerator(TableConfig tableConfig, Schema schema, @Nullable String prefix, @Nullable String postfix, @Nullable String fixedSegmentName, boolean excludeSequenceId) {
        String segmentNameGeneratorType = tableConfig.getIndexingConfig().getSegmentNameGeneratorType();
        if (segmentNameGeneratorType == null || segmentNameGeneratorType.isEmpty()) {
            segmentNameGeneratorType = SIMPLE_SEGMENT_NAME_GENERATOR;
        }
        String tableName = tableConfig.getTableName();
        switch (segmentNameGeneratorType.toLowerCase()) {
            case "fixed": {
                return new FixedSegmentNameGenerator(fixedSegmentName);
            }
            case "simple": {
                if (prefix != null) {
                    return new SimpleSegmentNameGenerator(prefix, postfix);
                }
                return new SimpleSegmentNameGenerator(tableName, postfix);
            }
            case "normalizeddate": {
                SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
                DateTimeFormatSpec dateTimeFormatSpec = null;
                String timeColumnName = validationConfig.getTimeColumnName();
                if (timeColumnName != null) {
                    DateTimeFieldSpec dateTimeFieldSpec = schema.getSpecForTimeColumn(timeColumnName);
                    Preconditions.checkNotNull((Object)dateTimeFieldSpec, (Object)"Schema does not contain the time column specified in the table config.");
                    dateTimeFormatSpec = new DateTimeFormatSpec(dateTimeFieldSpec.getFormat());
                }
                return new NormalizedDateSegmentNameGenerator(tableName, prefix, excludeSequenceId, IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)tableConfig), IngestionConfigUtils.getBatchSegmentIngestionFrequency((TableConfig)tableConfig), dateTimeFormatSpec, postfix);
            }
        }
        throw new UnsupportedOperationException("Unsupported segment name generator type: " + segmentNameGeneratorType);
    }
}

