/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;

public class SimpleSegmentNameGenerator
implements SegmentNameGenerator {
    private final String _segmentNamePrefix;
    private final String _segmentNamePostfix;

    public SimpleSegmentNameGenerator(String segmentNamePrefix, @Nullable String segmentNamePostfix) {
        Preconditions.checkArgument((segmentNamePrefix != null && this.isValidSegmentName(segmentNamePrefix) ? 1 : 0) != 0);
        Preconditions.checkArgument((segmentNamePostfix == null || this.isValidSegmentName(segmentNamePostfix) ? 1 : 0) != 0);
        this._segmentNamePrefix = segmentNamePrefix;
        this._segmentNamePostfix = segmentNamePostfix;
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        Preconditions.checkArgument((minTimeValue == null || this.isValidSegmentName(minTimeValue.toString()) ? 1 : 0) != 0);
        Preconditions.checkArgument((maxTimeValue == null || this.isValidSegmentName(maxTimeValue.toString()) ? 1 : 0) != 0);
        return JOINER.join((Object)this._segmentNamePrefix, minTimeValue, new Object[]{maxTimeValue, this._segmentNamePostfix, sequenceId >= 0 ? Integer.valueOf(sequenceId) : null});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SimpleSegmentNameGenerator: tableName=").append(this._segmentNamePrefix);
        if (this._segmentNamePostfix != null) {
            stringBuilder.append(", segmentNamePostfix=").append(this._segmentNamePostfix);
        }
        return stringBuilder.toString();
    }
}

