/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.index.creator.BloomFilterCreator;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.index.reader.SortedIndexReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.index.reader.provider.IndexReaderProvider;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingOverrides {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingOverrides.class);
    private static final IndexCreatorProvider CREATOR_DEFAULTS = IndexingOverrides.createDefaultCreatorProvider();
    private static final IndexReaderProvider READER_DEFAULTS = IndexingOverrides.createDefaultReaderProvider();
    private static final AtomicReference<IndexingOverride> REGISTRATION = new AtomicReference<Object>(null);

    private IndexingOverrides() {
    }

    public static boolean registerProvider(IndexingOverride provider) {
        return REGISTRATION.compareAndSet(null, provider);
    }

    public static IndexReaderProvider getIndexReaderProvider() {
        return Holder.PROVIDER;
    }

    public static IndexCreatorProvider getIndexCreatorProvider() {
        return Holder.PROVIDER;
    }

    private static IndexCreatorProvider createDefaultCreatorProvider() {
        return (IndexCreatorProvider)IndexingOverrides.invokeDefaultConstructor("org.apache.pinot.segment.local.segment.creator.impl.DefaultIndexCreatorProvider");
    }

    private static IndexReaderProvider createDefaultReaderProvider() {
        return (IndexReaderProvider)IndexingOverrides.invokeDefaultConstructor("org.apache.pinot.segment.local.segment.index.readers.DefaultIndexReaderProvider");
    }

    private static <T> T invokeDefaultConstructor(String className) {
        try {
            Class<?> clazz = Class.forName(className, false, IndexingOverrides.class.getClassLoader());
            return (T)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable missing) {
            LOGGER.error("could not construct MethodHandle for {}", (Object)className, (Object)missing);
            return null;
        }
    }

    static /* synthetic */ AtomicReference access$000() {
        return REGISTRATION;
    }

    public static class Default
    implements IndexingOverride {
        @Override
        public BloomFilterCreator newBloomFilterCreator(IndexCreationContext.BloomFilter context) throws IOException {
            this.ensureCreatorPresent();
            return CREATOR_DEFAULTS.newBloomFilterCreator(context);
        }

        @Override
        public ForwardIndexCreator newForwardIndexCreator(IndexCreationContext.Forward context) throws Exception {
            this.ensureCreatorPresent();
            return CREATOR_DEFAULTS.newForwardIndexCreator(context);
        }

        @Override
        public GeoSpatialIndexCreator newGeoSpatialIndexCreator(IndexCreationContext.Geospatial context) throws IOException {
            this.ensureCreatorPresent();
            return CREATOR_DEFAULTS.newGeoSpatialIndexCreator(context);
        }

        @Override
        public DictionaryBasedInvertedIndexCreator newInvertedIndexCreator(IndexCreationContext.Inverted context) throws IOException {
            this.ensureCreatorPresent();
            return CREATOR_DEFAULTS.newInvertedIndexCreator(context);
        }

        @Override
        public JsonIndexCreator newJsonIndexCreator(IndexCreationContext.Json context) throws IOException {
            this.ensureCreatorPresent();
            return CREATOR_DEFAULTS.newJsonIndexCreator(context);
        }

        @Override
        public CombinedInvertedIndexCreator newRangeIndexCreator(IndexCreationContext.Range context) throws IOException {
            this.ensureCreatorPresent();
            return CREATOR_DEFAULTS.newRangeIndexCreator(context);
        }

        @Override
        public TextIndexCreator newTextIndexCreator(IndexCreationContext.Text context) throws IOException {
            this.ensureCreatorPresent();
            return CREATOR_DEFAULTS.newTextIndexCreator(context);
        }

        @Override
        public BloomFilterReader newBloomFilterReader(PinotDataBuffer dataBuffer, boolean onHeap) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newBloomFilterReader(dataBuffer, onHeap);
        }

        @Override
        public ForwardIndexReader<?> newForwardIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newForwardIndexReader(dataBuffer, metadata);
        }

        @Override
        public H3IndexReader newGeospatialIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newGeospatialIndexReader(dataBuffer, metadata);
        }

        @Override
        public InvertedIndexReader<?> newInvertedIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newInvertedIndexReader(dataBuffer, metadata);
        }

        @Override
        public JsonIndexReader newJsonIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newJsonIndexReader(dataBuffer, metadata);
        }

        @Override
        public RangeIndexReader<?> newRangeIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newRangeIndexReader(dataBuffer, metadata);
        }

        @Override
        public SortedIndexReader<?> newSortedIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newSortedIndexReader(dataBuffer, metadata);
        }

        @Override
        public TextIndexReader newFSTIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IOException {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newFSTIndexReader(dataBuffer, metadata);
        }

        @Override
        public TextIndexReader newTextIndexReader(File file, ColumnMetadata columnMetadata, @Nullable Map<String, String> textIndexProperties) {
            this.ensureReaderPresent();
            return READER_DEFAULTS.newTextIndexReader(file, columnMetadata, textIndexProperties);
        }

        private void ensureReaderPresent() {
            if (READER_DEFAULTS == null) {
                throw new UnsupportedOperationException("default implementation not present on classpath");
            }
        }

        private void ensureCreatorPresent() {
            if (CREATOR_DEFAULTS == null) {
                throw new UnsupportedOperationException("default implementation not present on classpath");
            }
        }
    }

    private static final class Holder {
        public static final IndexingOverride PROVIDER = Optional.ofNullable((IndexingOverride)IndexingOverrides.access$000().get()).orElseGet(Default::new);

        private Holder() {
        }
    }

    public static interface IndexingOverride
    extends IndexCreatorProvider,
    IndexReaderProvider {
    }
}

