/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.creator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;

public class H3IndexConfig {
    public static final String RESOLUTIONS_KEY = "resolutions";
    private final H3IndexResolution _resolution;

    public H3IndexConfig(Map<String, String> properties) {
        Preconditions.checkArgument((properties != null && properties.containsKey(RESOLUTIONS_KEY) ? 1 : 0) != 0, (Object)"Properties must contain H3 resolutions");
        ArrayList<Integer> resolutions = new ArrayList<Integer>();
        try {
            for (String resolution : StringUtils.split((String)properties.get(RESOLUTIONS_KEY), (char)',')) {
                resolutions.add(Integer.parseInt(resolution));
            }
            this._resolution = new H3IndexResolution(resolutions);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("H3 index resolutions must be a list of integers, separated by comma", e);
        }
    }

    public H3IndexResolution getResolution() {
        return this._resolution;
    }
}

