/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.reader;

import java.io.Closeable;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.spi.data.FieldSpec;

public interface ForwardIndexReader<T extends ForwardIndexReaderContext>
extends Closeable {
    public boolean isDictionaryEncoded();

    public boolean isSingleValue();

    public FieldSpec.DataType getValueType();

    @Nullable
    default public T createContext() {
        return null;
    }

    default public int getDictId(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getDictIdMV(int docId, int[] dictIdBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public void readValuesSV(int[] docIds, int length, int[] values, T context) {
        switch (this.getValueType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (int)this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (int)this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (int)this.getDouble(docIds[i], context);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Integer.parseInt(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public void readValuesSV(int[] docIds, int length, long[] values, T context) {
        switch (this.getValueType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (long)this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (long)this.getDouble(docIds[i], context);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Long.parseLong(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public void readValuesSV(int[] docIds, int length, float[] values, T context) {
        switch (this.getValueType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (float)this.getDouble(docIds[i], context);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Float.parseFloat(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public void readValuesSV(int[] docIds, int length, double[] values, T context) {
        switch (this.getValueType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getDouble(docIds[i], context);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Double.parseDouble(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public int getInt(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public long getLong(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public float getFloat(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public double getDouble(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public String getString(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public byte[] getBytes(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getIntMV(int docId, int[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getLongMV(int docId, long[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getFloatMV(int docId, float[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getDoubleMV(int docId, double[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getStringMV(int docId, String[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getBytesMV(int docId, byte[][] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }
}

