/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition;

import com.google.common.base.Preconditions;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class HashCodePartitionFunction
implements PartitionFunction {
    private static final String NAME = "HashCode";
    private final int _numPartitions;

    public HashCodePartitionFunction(int numPartitions) {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (String)"Number of partitions must be > 0, specified", (int)numPartitions);
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(Object value) {
        return HashCodePartitionFunction.abs(value.toString().hashCode()) % this._numPartitions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }

    private static int abs(int n) {
        return n == Integer.MIN_VALUE ? 0 : Math.abs(n);
    }
}

