/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import io.airlift.units.Duration;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ResourceGroupGlobalProperties {
    private final Optional<Duration> cpuQuotaPeriod;

    public ResourceGroupGlobalProperties(Optional<Duration> cpuQuotaPeriod) {
        this.cpuQuotaPeriod = Objects.requireNonNull(cpuQuotaPeriod, "Cpu Quota Period is null");
    }

    public Optional<Duration> getCpuQuotaPeriod() {
        return this.cpuQuotaPeriod;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResourceGroupGlobalProperties)) {
            return false;
        }
        ResourceGroupGlobalProperties that = (ResourceGroupGlobalProperties)other;
        return this.cpuQuotaPeriod.equals(that.cpuQuotaPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.cpuQuotaPeriod);
    }

    public static class Mapper
    implements RowMapper<ResourceGroupGlobalProperties> {
        public ResourceGroupGlobalProperties map(ResultSet resultSet, StatementContext context) throws SQLException {
            return new ResourceGroupGlobalProperties(Optional.ofNullable(resultSet.getString("value")).map(Duration::valueOf));
        }
    }
}

