/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.oracle;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.DriverConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.oracle.OracleClient;
import com.facebook.presto.plugin.oracle.OracleConfig;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import oracle.jdbc.OracleDriver;

public class OracleClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).to(OracleClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BaseJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OracleConfig.class);
    }

    @Provides
    @Singleton
    public static ConnectionFactory connectionFactory(BaseJdbcConfig config, OracleConfig oracleConfig) throws SQLException {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("includeSynonyms", String.valueOf(oracleConfig.isSynonymsEnabled()));
        return new DriverConnectionFactory((Driver)new OracleDriver(), config.getConnectionUrl(), Optional.empty(), Optional.empty(), connectionProperties);
    }
}

