/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfStripeCacheData;
import com.facebook.presto.orc.metadata.PostScript;
import io.airlift.slice.Slice;
import java.util.Objects;
import java.util.Optional;

public class OrcFileTail {
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final int bufferSize;
    private final CompressionKind compressionKind;
    private final Slice footerSlice;
    private final int footerSize;
    private final Slice metadataSlice;
    private final int metadataSize;
    private final Optional<DwrfStripeCacheData> dwrfStripeCacheData;

    public OrcFileTail(PostScript.HiveWriterVersion hiveWriterVersion, int bufferSize, CompressionKind compressionKind, Slice footerSlice, int footerSize, Slice metadataSlice, int metadataSize, Optional<DwrfStripeCacheData> dwrfStripeCacheData) {
        this.hiveWriterVersion = Objects.requireNonNull(hiveWriterVersion, "hiveWriterVersion is null");
        this.bufferSize = bufferSize;
        this.compressionKind = Objects.requireNonNull(compressionKind, "compressionKind is null");
        this.footerSlice = Objects.requireNonNull(footerSlice, "footerSlice is null");
        this.footerSize = footerSize;
        this.metadataSlice = Objects.requireNonNull(metadataSlice, "metadataSlice is null");
        this.metadataSize = metadataSize;
        this.dwrfStripeCacheData = Objects.requireNonNull(dwrfStripeCacheData, "dwrfStripeCacheData is null");
    }

    public PostScript.HiveWriterVersion getHiveWriterVersion() {
        return this.hiveWriterVersion;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public Slice getFooterSlice() {
        return this.footerSlice;
    }

    public int getFooterSize() {
        return this.footerSize;
    }

    public Slice getMetadataSlice() {
        return this.metadataSlice;
    }

    public int getMetadataSize() {
        return this.metadataSize;
    }

    public Optional<DwrfStripeCacheData> getDwrfStripeCacheData() {
        return this.dwrfStripeCacheData;
    }

    private int getDwrfStripeCacheSize() {
        int dwrfStripeCacheSize = 0;
        if (this.dwrfStripeCacheData.isPresent()) {
            dwrfStripeCacheSize = this.dwrfStripeCacheData.get().getDwrfStripeCacheSize();
        }
        return dwrfStripeCacheSize;
    }

    public int getTotalSize() {
        return this.getFooterSize() + this.getMetadataSize() + this.getDwrfStripeCacheSize();
    }
}

