/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class OrcType {
    private final OrcTypeKind orcTypeKind;
    private final List<Integer> fieldTypeIndexes;
    private final List<String> fieldNames;
    private final Optional<Integer> length;
    private final Optional<Integer> precision;
    private final Optional<Integer> scale;
    private final Map<String, String> attributes;

    private OrcType(OrcTypeKind orcTypeKind) {
        this(orcTypeKind, (List<Integer>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private OrcType(OrcTypeKind orcTypeKind, int length) {
        this(orcTypeKind, (List<Integer>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.of(length), Optional.empty(), Optional.empty());
    }

    private OrcType(OrcTypeKind orcTypeKind, int precision, int scale) {
        this(orcTypeKind, (List<Integer>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.of(precision), Optional.of(scale));
    }

    private OrcType(OrcTypeKind orcTypeKind, List<Integer> fieldTypeIndexes, List<String> fieldNames) {
        this(orcTypeKind, fieldTypeIndexes, fieldNames, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public OrcType(OrcTypeKind orcTypeKind, List<Integer> fieldTypeIndexes, List<String> fieldNames, Optional<Integer> length, Optional<Integer> precision, Optional<Integer> scale) {
        this(orcTypeKind, fieldTypeIndexes, fieldNames, length, precision, scale, (Map<String, String>)ImmutableMap.of());
    }

    public OrcType(OrcTypeKind orcTypeKind, List<Integer> fieldTypeIndexes, List<String> fieldNames, Optional<Integer> length, Optional<Integer> precision, Optional<Integer> scale, Map<String, String> attributes) {
        this.orcTypeKind = Objects.requireNonNull(orcTypeKind, "typeKind is null");
        this.fieldTypeIndexes = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldTypeIndexes, "fieldTypeIndexes is null"));
        if (fieldNames == null || fieldNames.isEmpty() && !fieldTypeIndexes.isEmpty()) {
            this.fieldNames = null;
        } else {
            this.fieldNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldNames, "fieldNames is null"));
            Preconditions.checkArgument((fieldNames.size() == fieldTypeIndexes.size() ? 1 : 0) != 0, (Object)"fieldNames and fieldTypeIndexes have different sizes");
        }
        this.length = Objects.requireNonNull(length, "length is null");
        this.precision = Objects.requireNonNull(precision, "precision is null");
        this.scale = Objects.requireNonNull(scale, "scale can not be null");
        this.attributes = ImmutableMap.copyOf(Objects.requireNonNull(attributes, "attributes is null"));
    }

    public OrcTypeKind getOrcTypeKind() {
        return this.orcTypeKind;
    }

    public int getFieldCount() {
        return this.fieldTypeIndexes.size();
    }

    public int getFieldTypeIndex(int field) {
        return this.fieldTypeIndexes.get(field);
    }

    public List<Integer> getFieldTypeIndexes() {
        return this.fieldTypeIndexes;
    }

    public String getFieldName(int field) {
        return this.fieldNames.get(field);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Optional<Integer> getLength() {
        return this.length;
    }

    public Optional<Integer> getPrecision() {
        return this.precision;
    }

    public Optional<Integer> getScale() {
        return this.scale;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcTypeKind", (Object)this.orcTypeKind).add("fieldTypeIndexes", this.fieldTypeIndexes).add("fieldNames", this.fieldNames).toString();
    }

    @VisibleForTesting
    public static List<OrcType> toOrcType(int nextFieldTypeIndex, Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BOOLEAN));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BYTE));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.SHORT));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.INT));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.LONG));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DOUBLE));
        }
        if (RealType.REAL.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.FLOAT));
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return ImmutableList.of((Object)new OrcType(OrcTypeKind.STRING));
            }
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.VARCHAR, varcharType.getLengthSafe()));
        }
        if (type instanceof CharType) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.CHAR, ((CharType)type).getLength()));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BINARY));
        }
        if (DateType.DATE.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DATE));
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.TIMESTAMP));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DECIMAL, decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            return OrcType.createOrcArrayType(nextFieldTypeIndex, (Type)type.getTypeParameters().get(0));
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            return OrcType.createOrcMapType(nextFieldTypeIndex, (Type)type.getTypeParameters().get(0), (Type)type.getTypeParameters().get(1));
        }
        if (type.getTypeSignature().getBase().equals("row")) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (int i = 0; i < type.getTypeSignature().getParameters().size(); ++i) {
                TypeSignatureParameter parameter = (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i);
                fieldNames.add(parameter.getNamedTypeSignature().getName().orElse("field" + i));
            }
            List fieldTypes = type.getTypeParameters();
            return OrcType.createOrcRowType(nextFieldTypeIndex, fieldNames, fieldTypes);
        }
        throw new NotSupportedException(String.format("Unsupported Hive type: %s", type));
    }

    private static List<OrcType> createOrcArrayType(int nextFieldTypeIndex, Type itemType) {
        List<OrcType> itemTypes = OrcType.toOrcType(++nextFieldTypeIndex, itemType);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.LIST, (List<Integer>)ImmutableList.of((Object)nextFieldTypeIndex), (List<String>)ImmutableList.of((Object)"item")));
        orcTypes.addAll(itemTypes);
        return orcTypes;
    }

    private static List<OrcType> createOrcMapType(int nextFieldTypeIndex, Type keyType, Type valueType) {
        List<OrcType> keyTypes = OrcType.toOrcType(++nextFieldTypeIndex, keyType);
        List<OrcType> valueTypes = OrcType.toOrcType(nextFieldTypeIndex + keyTypes.size(), valueType);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.MAP, (List<Integer>)ImmutableList.of((Object)nextFieldTypeIndex, (Object)(nextFieldTypeIndex + keyTypes.size())), (List<String>)ImmutableList.of((Object)"key", (Object)"value")));
        orcTypes.addAll(keyTypes);
        orcTypes.addAll(valueTypes);
        return orcTypes;
    }

    public static List<OrcType> createOrcRowType(int nextFieldTypeIndex, List<String> fieldNames, List<Type> fieldTypes) {
        ++nextFieldTypeIndex;
        ArrayList<Integer> fieldTypeIndexes = new ArrayList<Integer>();
        ArrayList<List<OrcType>> fieldTypesList = new ArrayList<List<OrcType>>();
        for (Type fieldType : fieldTypes) {
            fieldTypeIndexes.add(nextFieldTypeIndex);
            List<OrcType> fieldOrcTypes = OrcType.toOrcType(nextFieldTypeIndex, fieldType);
            fieldTypesList.add(fieldOrcTypes);
            nextFieldTypeIndex += fieldOrcTypes.size();
        }
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.STRUCT, fieldTypeIndexes, fieldNames));
        fieldTypesList.forEach(orcTypes::addAll);
        return orcTypes;
    }

    public static Set<Integer> mapColumnToNode(Set<Integer> columnIndexes, List<OrcType> orcTypes) {
        Objects.requireNonNull(columnIndexes, "columnIndexes is null");
        Objects.requireNonNull(orcTypes, "orcTypes is null");
        if (columnIndexes.isEmpty()) {
            return ImmutableSet.of();
        }
        OrcType rootType = orcTypes.get(0);
        int fieldCount = rootType.getFieldCount();
        return (Set)columnIndexes.stream().filter(columnIndex -> columnIndex < fieldCount).map(rootType::getFieldTypeIndex).collect(ImmutableSet.toImmutableSet());
    }

    public static enum OrcTypeKind {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        DECIMAL,
        FLOAT,
        DOUBLE,
        STRING,
        VARCHAR,
        CHAR,
        BINARY,
        DATE,
        TIMESTAMP,
        LIST,
        MAP,
        STRUCT,
        UNION;

    }
}

