/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DoubleColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleColumnStatistics.class).instanceSize();
    private final DoubleStatistics doubleStatistics;

    public DoubleColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, DoubleStatistics doubleStatistics) {
        super(numberOfValues, bloomFilter);
        Objects.requireNonNull(doubleStatistics, "doubleStatistics is null");
        this.doubleStatistics = doubleStatistics;
    }

    @Override
    public DoubleStatistics getDoubleStatistics() {
        return this.doubleStatistics;
    }

    @Override
    public long getTotalValueSizeInBytes() {
        return this.getNumberOfValues() * 9L;
    }

    @Override
    public ColumnStatistics withBloomFilter(HiveBloomFilter bloomFilter) {
        return new DoubleColumnStatistics(this.getNumberOfValues(), bloomFilter, this.doubleStatistics);
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)INSTANCE_SIZE + this.getMembersSizeInBytes();
        return sizeInBytes + this.doubleStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.doubleStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("doubleStatistics", (Object)this.doubleStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleColumnStatistics that = (DoubleColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.doubleStatistics, that.doubleStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.doubleStatistics);
    }
}

