/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class StatisticsHasher {
    private final Hasher hasher = Hashing.goodFastHash((int)64).newHasher();

    public StatisticsHasher putByte(byte value) {
        this.hasher.putByte(value);
        return this;
    }

    public StatisticsHasher putBytes(byte[] bytes) {
        this.hasher.putBytes(bytes);
        return this;
    }

    public StatisticsHasher putBytes(byte[] bytes, int off, int len) {
        this.hasher.putBytes(bytes, off, len);
        return this;
    }

    public StatisticsHasher putBytes(ByteBuffer bytes) {
        this.hasher.putBytes(bytes);
        return this;
    }

    public StatisticsHasher putShort(short value) {
        this.hasher.putShort(value);
        return this;
    }

    public StatisticsHasher putInt(int value) {
        this.hasher.putInt(value);
        return this;
    }

    public StatisticsHasher putOptionalInt(boolean present, int value) {
        this.hasher.putBoolean(present);
        this.hasher.putInt(present ? value : 0);
        return this;
    }

    public StatisticsHasher putLong(long value) {
        this.hasher.putLong(value);
        return this;
    }

    public StatisticsHasher putOptionalLong(boolean present, long value) {
        this.hasher.putBoolean(present);
        this.hasher.putLong(present ? value : 0L);
        return this;
    }

    public StatisticsHasher putFloat(float value) {
        this.hasher.putFloat(value);
        return this;
    }

    public StatisticsHasher putDouble(double value) {
        this.hasher.putDouble(value);
        return this;
    }

    public StatisticsHasher putOptionalDouble(boolean present, double value) {
        this.hasher.putBoolean(present);
        this.hasher.putDouble(present ? value : 0.0);
        return this;
    }

    public StatisticsHasher putBoolean(boolean value) {
        this.hasher.putBoolean(value);
        return this;
    }

    public StatisticsHasher putOptionalHashable(Hashable value) {
        this.hasher.putBoolean(value != null);
        if (value != null) {
            value.addHash(this);
        }
        return this;
    }

    public StatisticsHasher putOptionalSlice(Slice value) {
        this.hasher.putBoolean(value != null);
        if (value != null) {
            this.hasher.putBytes(value.getBytes());
        }
        return this;
    }

    public StatisticsHasher putOptionalBigDecimal(BigDecimal value) {
        this.hasher.putBoolean(value != null);
        if (value != null) {
            this.hasher.putInt(value.scale());
            this.hasher.putBytes(value.unscaledValue().toByteArray());
        }
        return this;
    }

    public long hash() {
        return this.hasher.hash().asLong();
    }

    public void putLongs(long[] array) {
        this.hasher.putInt(array.length);
        for (long entry : array) {
            this.hasher.putLong(entry);
        }
    }

    public static interface Hashable {
        public void addHash(StatisticsHasher var1);
    }
}

