/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BatchStreamReaders;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class ListBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ListBatchStreamReader.class).instanceSize();
    private final Type elementType;
    private final StreamDescriptor streamDescriptor;
    private final BatchStreamReader elementStreamReader;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;

    public ListBatchStreamReader(Type type, StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, OrcAggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, ArrayType.class::isInstance);
        this.elementType = ((ArrayType)type).getElementType();
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.elementStreamReader = BatchStreamReaders.createStreamReader(this.elementType, streamDescriptor.getNestedStreams().get(0), hiveStorageTimeZone, options, systemMemoryContext);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block elements;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                long elementSkipSize = this.lengthStream.sum(this.readOffset);
                this.elementStreamReader.prepareNextRead(Math.toIntExact(elementSkipSize));
            }
        }
        int[] offsetVector = new int[this.nextBatchSize + 1];
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            this.lengthStream.next(offsetVector, this.nextBatchSize);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.lengthStream.next(offsetVector, this.nextBatchSize - nullValues);
                ReaderUtils.unpackLengthNulls(offsetVector, nullVector, this.nextBatchSize - nullValues);
            }
        }
        ReaderUtils.convertLengthVectorToOffsetVector(offsetVector);
        int elementCount = offsetVector[offsetVector.length - 1];
        if (elementCount > 0) {
            this.elementStreamReader.prepareNextRead(elementCount);
            elements = this.elementStreamReader.readBlock();
        } else {
            elements = this.elementType.createBlockBuilder(null, 0).build();
        }
        Block arrayBlock = ArrayBlock.fromElementBlock((int)this.nextBatchSize, Optional.ofNullable(nullVector), (int[])offsetVector, (Block)elements);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return arrayBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(Stripe stripe) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.elementStreamReader.startStripe(stripe);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.elementStreamReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.elementStreamReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.elementStreamReader.getRetainedSizeInBytes();
    }
}

