/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class DictionaryRowGroup {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DictionaryRowGroup.class).instanceSize();
    private final byte[][] byteSegments;
    private final short[][] shortSegments;
    private final int[][] intSegments;
    private final ColumnStatistics columnStatistics;

    public DictionaryRowGroup(byte[][] byteSegments, short[][] shortSegments, int[][] intSegments, ColumnStatistics columnStatistics) {
        Objects.requireNonNull(columnStatistics, "columnStatistics is null");
        Preconditions.checkArgument((byteSegments != null || shortSegments != null || intSegments != null ? 1 : 0) != 0, (Object)"All segments are null");
        this.byteSegments = byteSegments;
        this.shortSegments = shortSegments;
        this.intSegments = intSegments;
        this.columnStatistics = columnStatistics;
    }

    public byte[][] getByteSegments() {
        return this.byteSegments;
    }

    public short[][] getShortSegments() {
        return this.shortSegments;
    }

    public int[][] getIntSegments() {
        return this.intSegments;
    }

    public ColumnStatistics getColumnStatistics() {
        return this.columnStatistics;
    }

    public long getShallowRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.byteSegments) + SizeOf.sizeOf((Object[])this.shortSegments) + SizeOf.sizeOf((Object[])this.intSegments) + this.columnStatistics.getRetainedSizeInBytes();
    }
}

