/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.AbstractVariableWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.stream.ByteArrayOutputStream;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryBuilder;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryColumnWriter
extends DictionaryColumnWriter {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryColumnWriter.class).instanceSize();
    private static final int DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES = Math.toIntExact(new DataSize(32.0, DataSize.Unit.MEGABYTE).toBytes());
    private static final int EXPECTED_ENTRIES = 1024;
    private final AbstractVariableWidthType type;
    private ByteArrayOutputStream dictionaryDataStream;
    private LongOutputStream dictionaryLengthStream;
    private final int stringStatisticsLimitInBytes;
    private final boolean sortDictionaryKeys;
    private SliceDictionaryBuilder dictionary = new SliceDictionaryBuilder(1024);
    private StringStatisticsBuilder statisticsBuilder;
    private ColumnEncoding columnEncoding;
    private SliceDirectColumnWriter directColumnWriter;

    public SliceDictionaryColumnWriter(int column, int sequence, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, MetadataWriter metadataWriter) {
        super(column, sequence, columnWriterOptions, dwrfEncryptor, orcEncoding, metadataWriter);
        Preconditions.checkArgument((boolean)(type instanceof AbstractVariableWidthType), (Object)"Not an instance of AbstractVariableWidthType");
        this.type = (AbstractVariableWidthType)type;
        this.dictionaryDataStream = new ByteArrayOutputStream(columnWriterOptions, dwrfEncryptor, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionaryLengthStream = LongOutputStream.createLengthOutputStream(columnWriterOptions, dwrfEncryptor, orcEncoding);
        this.stringStatisticsLimitInBytes = columnWriterOptions.getStringStatisticsLimit();
        this.statisticsBuilder = this.newStringStatisticsBuilder();
        this.sortDictionaryKeys = columnWriterOptions.isStringDictionarySortingEnabled();
        Preconditions.checkState((this.sortDictionaryKeys || orcEncoding == OrcEncoding.DWRF ? 1 : 0) != 0, (Object)"Disabling sort is only supported in DWRF format");
    }

    @Override
    public int getDictionaryBytes() {
        Preconditions.checkState((!this.isDirectEncoded() ? 1 : 0) != 0);
        return Math.toIntExact(this.dictionary.getSizeInBytes());
    }

    @Override
    public int getDictionaryEntries() {
        Preconditions.checkState((!this.isDirectEncoded() ? 1 : 0) != 0);
        return this.dictionary.getEntryCount();
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, int[] dictionaryIndexes, int maxDirectBytes) {
        long size = 0L;
        for (int offset = 0; offset < dictionaryIndexCount; ++offset) {
            int dictionaryIndex = dictionaryIndexes[offset];
            if ((size += this.writeDirectEntry(dictionaryIndex)) <= (long)DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES) continue;
            if (this.directColumnWriter.getBufferedBytes() > (long)maxDirectBytes) {
                return false;
            }
            size = 0L;
        }
        return this.directColumnWriter.getBufferedBytes() <= (long)maxDirectBytes;
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, short[] dictionaryIndexes, int maxDirectBytes) {
        long size = 0L;
        for (int offset = 0; offset < dictionaryIndexCount; ++offset) {
            short dictionaryIndex = dictionaryIndexes[offset];
            if ((size += this.writeDirectEntry(dictionaryIndex)) <= (long)DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES) continue;
            if (this.directColumnWriter.getBufferedBytes() > (long)maxDirectBytes) {
                return false;
            }
            size = 0L;
        }
        return this.directColumnWriter.getBufferedBytes() <= (long)maxDirectBytes;
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, byte[] dictionaryIndexes, int maxDirectBytes) {
        long size = 0L;
        for (int offset = 0; offset < dictionaryIndexCount; ++offset) {
            byte dictionaryIndex = dictionaryIndexes[offset];
            if ((size += this.writeDirectEntry(dictionaryIndex)) <= (long)DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES) continue;
            if (this.directColumnWriter.getBufferedBytes() > (long)maxDirectBytes) {
                return false;
            }
            size = 0L;
        }
        return this.directColumnWriter.getBufferedBytes() <= (long)maxDirectBytes;
    }

    private long writeDirectEntry(int dictionaryIndex) {
        return this.directColumnWriter.writeBlockPosition(this.dictionary.getBlock(), dictionaryIndex);
    }

    @Override
    protected ColumnEncoding getDictionaryColumnEncoding() {
        Preconditions.checkState((this.columnEncoding != null ? 1 : 0) != 0);
        return this.columnEncoding;
    }

    @Override
    protected DictionaryColumnWriter.BlockStatistics addBlockToDictionary(Block block, int rowGroupOffset, int[] rowGroupIndexes) {
        int nonNullValueCount = 0;
        long rawBytes = 0L;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            rowGroupIndexes[rowGroupOffset++] = this.dictionary.putIfAbsent(block, position);
            this.statisticsBuilder.addValue(block, position);
            rawBytes += (long)block.getSliceLength(position);
            ++nonNullValueCount;
        }
        long rawBytesIncludingNulls = rawBytes + (long)(block.getPositionCount() - nonNullValueCount) * 1L;
        return new DictionaryColumnWriter.BlockStatistics(nonNullValueCount, rawBytes, rawBytesIncludingNulls);
    }

    @Override
    protected void closeDictionary() {
        this.dictionary = null;
        this.dictionaryDataStream.close();
        this.dictionaryLengthStream.close();
    }

    @Override
    protected ColumnStatistics createColumnStatistics() {
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.statisticsBuilder = this.newStringStatisticsBuilder();
        return statistics;
    }

    private static int[] getSortedDictionary(SliceDictionaryBuilder dictionary) {
        int[] sortedPositions = new int[dictionary.getEntryCount()];
        for (int i = 0; i < sortedPositions.length; ++i) {
            sortedPositions[i] = i;
        }
        IntArrays.quickSort((int[])sortedPositions, (int)0, (int)sortedPositions.length, dictionary::compareIndex);
        return sortedPositions;
    }

    @Override
    protected void beginDataRowGroup() {
        this.directColumnWriter.beginDataRowGroup();
    }

    @Override
    protected void movePresentStreamToDirectWriter(PresentOutputStream presentStream) {
        this.directColumnWriter.updatePresentStream(presentStream);
    }

    @Override
    protected Optional<int[]> writeDictionary() {
        ColumnEncoding.ColumnEncodingKind encodingKind = this.orcEncoding == OrcEncoding.DWRF ? ColumnEncoding.ColumnEncodingKind.DICTIONARY : ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2;
        int dictionaryEntryCount = this.dictionary.getEntryCount();
        this.columnEncoding = new ColumnEncoding(encodingKind, dictionaryEntryCount);
        if (this.sortDictionaryKeys) {
            return this.writeSortedDictionary();
        }
        for (int i = 0; i < dictionaryEntryCount; ++i) {
            this.writeDictionaryEntry(i);
        }
        return Optional.empty();
    }

    private Optional<int[]> writeSortedDictionary() {
        int[] sortedDictionaryIndexes;
        for (int sortedDictionaryIndex : sortedDictionaryIndexes = SliceDictionaryColumnWriter.getSortedDictionary(this.dictionary)) {
            this.writeDictionaryEntry(sortedDictionaryIndex);
        }
        int[] originalDictionaryToSortedIndex = new int[sortedDictionaryIndexes.length];
        int sortOrdinal = 0;
        while (sortOrdinal < sortedDictionaryIndexes.length) {
            int dictionaryIndex = sortedDictionaryIndexes[sortOrdinal];
            originalDictionaryToSortedIndex[dictionaryIndex] = sortOrdinal++;
        }
        return Optional.of(originalDictionaryToSortedIndex);
    }

    private void writeDictionaryEntry(int dictionaryIndex) {
        int length = this.dictionary.getSliceLength(dictionaryIndex);
        this.dictionaryLengthStream.writeLong(length);
        this.dictionaryDataStream.writeBlockPosition(this.dictionary.getBlock(), dictionaryIndex, 0, length);
    }

    @Override
    protected void writeDataStreams(int rowGroupValueCount, int[] rowGroupIndexes, Optional<int[]> optionalSortedIndex, LongOutputStream dataStream) {
        Preconditions.checkState((optionalSortedIndex.isPresent() == this.sortDictionaryKeys ? 1 : 0) != 0, (String)"SortedIndex and sortDictionaryKeys(%s) are inconsistent", (Object)this.sortDictionaryKeys);
        if (this.sortDictionaryKeys) {
            int[] sortedIndexes = optionalSortedIndex.get();
            for (int position = 0; position < rowGroupValueCount; ++position) {
                int originalDictionaryIndex = rowGroupIndexes[position];
                int sortedIndex = sortedIndexes[originalDictionaryIndex];
                this.writeIndex(dataStream, position, sortedIndex);
            }
        } else {
            for (int position = 0; position < rowGroupValueCount; ++position) {
                int dictionaryIndex = rowGroupIndexes[position];
                this.writeIndex(dataStream, position, dictionaryIndex);
            }
        }
    }

    @Override
    protected void writeDataStreams(int rowGroupValueCount, byte[] rowGroupIndexes, Optional<int[]> optionalSortedIndex, LongOutputStream dataStream) {
        Preconditions.checkState((optionalSortedIndex.isPresent() == this.sortDictionaryKeys ? 1 : 0) != 0, (String)"SortedIndex and sortDictionaryKeys(%s) are inconsistent", (Object)this.sortDictionaryKeys);
        if (this.sortDictionaryKeys) {
            int[] sortedIndexes = optionalSortedIndex.get();
            for (int position = 0; position < rowGroupValueCount; ++position) {
                byte originalDictionaryIndex = rowGroupIndexes[position];
                int sortedIndex = sortedIndexes[originalDictionaryIndex];
                this.writeIndex(dataStream, position, sortedIndex);
            }
        } else {
            for (int position = 0; position < rowGroupValueCount; ++position) {
                byte dictionaryIndex = rowGroupIndexes[position];
                this.writeIndex(dataStream, position, dictionaryIndex);
            }
        }
    }

    @Override
    protected void writeDataStreams(int rowGroupValueCount, short[] rowGroupIndexes, Optional<int[]> optionalSortedIndex, LongOutputStream dataStream) {
        Preconditions.checkState((optionalSortedIndex.isPresent() == this.sortDictionaryKeys ? 1 : 0) != 0, (String)"SortedIndex and sortDictionaryKeys(%s) are inconsistent", (Object)this.sortDictionaryKeys);
        if (this.sortDictionaryKeys) {
            int[] sortedIndexes = optionalSortedIndex.get();
            for (int position = 0; position < rowGroupValueCount; ++position) {
                short originalDictionaryIndex = rowGroupIndexes[position];
                int sortedIndex = sortedIndexes[originalDictionaryIndex];
                this.writeIndex(dataStream, position, sortedIndex);
            }
        } else {
            for (int position = 0; position < rowGroupValueCount; ++position) {
                short dictionaryIndex = rowGroupIndexes[position];
                this.writeIndex(dataStream, position, dictionaryIndex);
            }
        }
    }

    private void writeIndex(LongOutputStream dataStream, int position, int dictionaryIndex) {
        if (dictionaryIndex < 0) {
            throw new IllegalArgumentException(String.format("Invalid index %s at position %s", dictionaryIndex, position));
        }
        dataStream.writeLong(dictionaryIndex);
    }

    @Override
    protected long getRetainedDictionaryBytes() {
        return INSTANCE_SIZE + this.dictionaryDataStream.getRetainedBytes() + this.dictionaryLengthStream.getRetainedBytes() + this.dictionary.getRetainedSizeInBytes() + (this.directColumnWriter == null ? 0L : this.directColumnWriter.getRetainedBytes());
    }

    @Override
    protected void resetDictionary() {
        this.columnEncoding = null;
        this.dictionary = new SliceDictionaryBuilder(1024);
        this.dictionaryDataStream = new ByteArrayOutputStream(this.columnWriterOptions, this.dwrfEncryptor, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionaryLengthStream = LongOutputStream.createLengthOutputStream(this.columnWriterOptions, this.dwrfEncryptor, this.orcEncoding);
        this.statisticsBuilder = this.newStringStatisticsBuilder();
    }

    private StringStatisticsBuilder newStringStatisticsBuilder() {
        return new StringStatisticsBuilder(this.stringStatisticsLimitInBytes);
    }

    @Override
    protected ColumnWriter createDirectColumnWriter() {
        if (this.directColumnWriter == null) {
            this.directColumnWriter = new SliceDirectColumnWriter(this.column, this.sequence, (Type)this.type, this.columnWriterOptions, this.dwrfEncryptor, this.orcEncoding, this::newStringStatisticsBuilder, this.metadataWriter);
        }
        return this.directColumnWriter;
    }

    @Override
    protected ColumnWriter getDirectColumnWriter() {
        Preconditions.checkState((this.directColumnWriter != null ? 1 : 0) != 0);
        return this.directColumnWriter;
    }

    @Override
    protected List<StreamDataOutput> getDictionaryStreams(int column, int sequence) {
        return ImmutableList.of((Object)this.dictionaryLengthStream.getStreamDataOutput(column, sequence), (Object)this.dictionaryDataStream.getStreamDataOutput(column, sequence));
    }
}

