/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.text;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.rcfile.ColumnData;
import com.facebook.presto.rcfile.EncodeOutput;
import com.facebook.presto.rcfile.RcFileCorruptionException;
import com.facebook.presto.rcfile.text.TextColumnEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public abstract class BlockEncoding
implements TextColumnEncoding {
    private final Type type;
    protected final Slice nullSequence;
    private final byte[] separators;
    private final Byte escapeByte;

    public BlockEncoding(Type type, Slice nullSequence, byte[] separators, Byte escapeByte) {
        this.type = type;
        this.nullSequence = nullSequence;
        this.separators = separators;
        this.escapeByte = escapeByte;
    }

    @Override
    public final void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) throws RcFileCorruptionException {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValueInto(1, block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public final Block decodeColumn(ColumnData columnData) throws RcFileCorruptionException {
        int size = columnData.rowCount();
        Slice slice = columnData.getSlice();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            int offset = columnData.getOffset(i);
            if (!this.isNullSequence(slice, offset, length)) {
                this.decodeValueInto(1, builder, slice, offset, length);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    protected final boolean isNullSequence(Slice slice, int offset, int length) {
        return this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length);
    }

    protected final boolean isEscapeByte(byte currentByte) {
        return this.escapeByte != null && currentByte == this.escapeByte;
    }

    protected final byte getSeparator(int depth) {
        return this.separators[depth];
    }
}

