/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.redis.RedisConnector;
import com.facebook.presto.redis.RedisConnectorConfig;
import com.facebook.presto.redis.RedisDecoderModule;
import com.facebook.presto.redis.RedisJedisManager;
import com.facebook.presto.redis.RedisMetadata;
import com.facebook.presto.redis.RedisRecordSetProvider;
import com.facebook.presto.redis.RedisSplitManager;
import com.facebook.presto.redis.RedisTableDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Objects;
import javax.inject.Inject;

public class RedisConnectorModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(RedisConnector.class).in(Scopes.SINGLETON);
        binder.bind(RedisMetadata.class).in(Scopes.SINGLETON);
        binder.bind(RedisSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(RedisRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(RedisJedisManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(RedisConnectorConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(RedisTableDescription.class);
        binder.install((Module)new RedisDecoderModule());
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final long serialVersionUID = 1L;
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)value);
            return type;
        }
    }
}

