/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis.decoder.hash;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

class HashRedisValueProvider
extends FieldValueProvider {
    protected final DecoderColumnHandle columnHandle;
    protected final String value;

    public HashRedisValueProvider(DecoderColumnHandle columnHandle, String value) {
        this.columnHandle = columnHandle;
        this.value = value;
    }

    public boolean isNull() {
        return this.value == null || this.value.isEmpty();
    }

    public boolean getBoolean() {
        return this.isNull() ? false : Boolean.parseBoolean(this.value.trim());
    }

    public long getLong() {
        return Long.parseLong(this.value.trim());
    }

    public double getDouble() {
        return Double.parseDouble(this.value.trim());
    }

    public Slice getSlice() {
        return Slices.utf8Slice((String)this.value);
    }
}

