/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode.expression;

import com.facebook.airlift.bytecode.BytecodeBlock;
import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.MethodGenerationContext;
import com.facebook.airlift.bytecode.expression.BytecodeExpression;
import com.facebook.airlift.bytecode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class InlineIfBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression condition;
    private final BytecodeExpression ifTrue;
    private final BytecodeExpression ifFalse;

    InlineIfBytecodeExpression(BytecodeExpression condition, BytecodeExpression ifTrue, BytecodeExpression ifFalse) {
        super(ifTrue.getType());
        this.condition = condition;
        this.ifTrue = Objects.requireNonNull(ifTrue, "ifTrue is null");
        this.ifFalse = Objects.requireNonNull(ifFalse, "ifFalse is null");
        Preconditions.checkArgument((condition.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected condition to be type boolean but is %s", (Object)condition.getType());
        Preconditions.checkArgument((boolean)ifTrue.getType().equals(ifFalse.getType()), (Object)"Expected ifTrue and ifFalse to be the same type");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        LabelNode falseLabel = new LabelNode("false");
        LabelNode endLabel = new LabelNode("end");
        return new BytecodeBlock().append(this.condition).ifFalseGoto(falseLabel).append(this.ifTrue).gotoLabel(endLabel).visitLabel(falseLabel).append(this.ifFalse).visitLabel(endLabel);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.condition, (Object)this.ifTrue, (Object)this.ifFalse);
    }

    @Override
    protected String formatOneLine() {
        return "(" + this.condition + " ? " + this.ifTrue + " : " + this.ifFalse + ")";
    }
}

