/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.common.block.SortOrder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.ListIndexesIterable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bson.Document;

public class MongoIndex {
    private final String name;
    private final List<MongodbIndexKey> keys;
    private final boolean unique;

    public static List<MongoIndex> parse(ListIndexesIterable<Document> indexes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Document index : indexes) {
            Document key = (Document)index.get((Object)"key");
            String name = index.getString((Object)"name");
            boolean unique = index.getBoolean((Object)"unique", false);
            if (key.containsKey((Object)"_fts")) continue;
            builder.add((Object)new MongoIndex(name, MongoIndex.parseKey(key), unique));
        }
        return builder.build();
    }

    private static List<MongodbIndexKey> parseKey(Document key) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : key.keySet()) {
            Object value = key.get((Object)name);
            if (value instanceof Number) {
                int order = ((Number)value).intValue();
                Preconditions.checkState((order == 1 || order == -1 ? 1 : 0) != 0, (Object)"Unknown index sort order");
                builder.add((Object)new MongodbIndexKey(name, order == 1 ? SortOrder.ASC_NULLS_LAST : SortOrder.DESC_NULLS_LAST));
                continue;
            }
            if (value instanceof String) {
                builder.add((Object)new MongodbIndexKey(name, (String)value));
                continue;
            }
            throw new UnsupportedOperationException("Unknown index type: " + value.toString());
        }
        return builder.build();
    }

    public MongoIndex(String name, List<MongodbIndexKey> keys, boolean unique) {
        this.name = name;
        this.keys = keys;
        this.unique = unique;
    }

    public String getName() {
        return this.name;
    }

    public List<MongodbIndexKey> getKeys() {
        return this.keys;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public static class MongodbIndexKey {
        private final String name;
        private final Optional<SortOrder> sortOrder;
        private final Optional<String> type;

        public MongodbIndexKey(String name, SortOrder sortOrder) {
            this(name, Optional.of(sortOrder), Optional.empty());
        }

        public MongodbIndexKey(String name, String type) {
            this(name, Optional.empty(), Optional.of(type));
        }

        public MongodbIndexKey(String name, Optional<SortOrder> sortOrder, Optional<String> type) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.sortOrder = sortOrder;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Optional<SortOrder> getSortOrder() {
            return this.sortOrder;
        }

        public Optional<String> getType() {
            return this.type;
        }
    }
}

