/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoColumnHandle;
import com.facebook.presto.mongodb.MongoPageSource;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.MongoSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class MongoPageSourceProvider
implements ConnectorPageSourceProvider {
    private final MongoSession mongoSession;

    @Inject
    public MongoPageSourceProvider(MongoSession mongoSession) {
        this.mongoSession = Objects.requireNonNull(mongoSession, "mongoSession is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        MongoSplit mongodbSplit = (MongoSplit)split;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle handle : Objects.requireNonNull(columns, "columns is null")) {
            handles.add((Object)((MongoColumnHandle)handle));
        }
        return new MongoPageSource(this.mongoSession, mongodbSplit, (List<MongoColumnHandle>)handles.build());
    }
}

