/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.ParquetDataSourceId;
import com.facebook.presto.parquet.ParquetErrorCode;
import com.facebook.presto.parquet.PrimitiveField;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Joiner;

public class ParquetResultVerifierUtils {
    private ParquetResultVerifierUtils() {
    }

    public static void verifyColumnChunks(ColumnChunk actual, ColumnChunk expected, boolean isNestedColumn, PrimitiveField field, ParquetDataSourceId sourceId) {
        Block actualBlock = actual.getBlock();
        Block expectedBlock = expected.getBlock();
        Type type = field.getType();
        String column = Joiner.on((String)".").join((Object[])field.getDescriptor().getPath());
        if (actualBlock.getPositionCount() != expectedBlock.getPositionCount()) {
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_INCORRECT_DECODING, String.format("Wrong count: ex=%d, act=%d, col=%s, file=%s", expectedBlock.getPositionCount(), actualBlock.getPositionCount(), column, sourceId));
        }
        for (int position = 0; position < actualBlock.getPositionCount(); ++position) {
            Object expectedValue;
            Object actualValue;
            if (type.equals(TimestampType.TIMESTAMP)) {
                actualValue = actualBlock.isNull(position) ? null : Long.valueOf(type.getLong(actualBlock, position));
                expectedValue = expectedBlock.isNull(position) ? null : Long.valueOf(type.getLong(expectedBlock, position));
            } else {
                actualValue = type.getObjectValue(null, actualBlock, position);
                expectedValue = type.getObjectValue(null, expectedBlock, position);
            }
            if (!(actualValue == null || expectedValue == null ? actualValue != expectedValue : !actualValue.equals(expectedValue))) continue;
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_INCORRECT_DECODING, String.format("Wrong value: pos=%d, ex=%s, act=%s, col=%s-%s, file=%s", position, expectedValue, actualValue, column, type, sourceId));
        }
        if (isNestedColumn) {
            int[] expectedDLs;
            int[] expectedRLs;
            int[] actualRLs = actual.getRepetitionLevels();
            if (actualRLs.length != (expectedRLs = expected.getRepetitionLevels()).length) {
                throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_INCORRECT_DECODING, String.format("Wrong RL count: ex=%s, act=%s, col=%s-%s, file=%s", expectedRLs.length, actualRLs.length, column, type, sourceId));
            }
            for (int i = 0; i < actualRLs.length; ++i) {
                if (actualRLs[i] == expectedRLs[i]) continue;
                throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_INCORRECT_DECODING, String.format("Wrong RL value: pos=%d, ex=%s, act=%s, col=%s-%s, file=%s", i, expectedRLs[i], actualRLs[i], column, type, sourceId));
            }
            int[] actualDLs = actual.getDefinitionLevels();
            if (actualDLs.length != (expectedDLs = expected.getDefinitionLevels()).length) {
                throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_INCORRECT_DECODING, String.format("Wrong DL count: ex=%s, act=%s, col=%s-%s, file=%s", expectedDLs.length, actualDLs.length, column, type, sourceId));
            }
            for (int i = 0; i < actualDLs.length; ++i) {
                if (actualDLs[i] == expectedDLs[i]) continue;
                throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_INCORRECT_DECODING, String.format("Wrong RL value: pos=%d, ex=%s, act=%s, col=%s-%s, file=%s", i, expectedDLs[i], actualDLs[i], column, type, sourceId));
            }
        }
    }
}

