/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.delta;

import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import org.apache.parquet.io.api.Binary;

public class BinaryDeltaValuesDecoder
implements ValuesDecoder.BinaryValuesDecoder {
    private final ValuesReader innerReader;

    public BinaryDeltaValuesDecoder(ParquetEncoding encoding, int valueCount, ByteBufferInputStream bufferInputStream) throws IOException {
        if (encoding == ParquetEncoding.DELTA_BYTE_ARRAY) {
            this.innerReader = new DeltaByteArrayReader();
        } else if (encoding == ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY) {
            this.innerReader = new DeltaLengthByteArrayValuesReader();
        } else {
            throw new IllegalArgumentException("Unsupported encoding: " + (Object)((Object)encoding));
        }
        this.innerReader.initFromPage(valueCount, bufferInputStream);
    }

    @Override
    public ValuesDecoder.BinaryValuesDecoder.ValueBuffer readNext(int length) throws IOException {
        Binary[] values = new Binary[length];
        int bufferSize = 0;
        for (int i = 0; i < length; ++i) {
            Binary value;
            values[i] = value = this.innerReader.readBytes();
            bufferSize += value.length();
        }
        return new DeltaValueBuffer(values, bufferSize);
    }

    @Override
    public int readIntoBuffer(byte[] byteBuffer, int bufferIndex, int[] offsets, int offsetIndex, ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer) {
        Preconditions.checkArgument((byteBuffer.length - bufferIndex >= valueBuffer.getBufferSize() ? 1 : 0) != 0, (Object)"not enough space in the input buffer");
        DeltaValueBuffer deltaValueBuffer = (DeltaValueBuffer)valueBuffer;
        Binary[] values = deltaValueBuffer.values;
        for (int i = 0; i < values.length; ++i) {
            Binary value = values[i];
            offsets[offsetIndex++] = bufferIndex;
            byte[] valueBytes = value.getBytes();
            System.arraycopy(valueBytes, 0, byteBuffer, bufferIndex, valueBytes.length);
            bufferIndex += valueBytes.length;
        }
        offsets[offsetIndex] = bufferIndex;
        return bufferIndex;
    }

    @Override
    public void skip(int length) throws IOException {
        while (length > 0) {
            this.innerReader.skip();
            --length;
        }
    }

    private static class DeltaValueBuffer
    implements ValuesDecoder.BinaryValuesDecoder.ValueBuffer {
        private final Binary[] values;
        private final int bufferSize;

        public DeltaValueBuffer(Binary[] values, int bufferSize) {
            this.values = values;
            this.bufferSize = bufferSize;
        }

        @Override
        public int getBufferSize() {
            return this.bufferSize;
        }
    }
}

