/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.TimestampDictionary;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.ParquetDecodingException;

public class TimestampRLEDictionaryValuesDecoder
extends BaseRLEBitPackedDecoder
implements ValuesDecoder.TimestampValuesDecoder {
    private final TimestampDictionary dictionary;

    public TimestampRLEDictionaryValuesDecoder(int bitWidth, InputStream inputStream, TimestampDictionary dictionary) {
        super(Integer.MAX_VALUE, bitWidth, inputStream);
        this.dictionary = dictionary;
    }

    @Override
    public void readNext(long[] values, int offset, int length) throws IOException {
        int remainingToCopy;
        int numEntriesToFill;
        int destinationIndex = offset;
        for (remainingToCopy = length; remainingToCopy > 0 && (this.currentCount != 0 || this.decode()); remainingToCopy -= numEntriesToFill) {
            numEntriesToFill = Math.min(remainingToCopy, this.currentCount);
            int endIndex = destinationIndex + numEntriesToFill;
            switch (this.mode) {
                case RLE: {
                    int rleValue = this.currentValue;
                    long rleValueMillis = this.dictionary.decodeToLong(rleValue);
                    while (destinationIndex < endIndex) {
                        values[destinationIndex++] = rleValueMillis;
                    }
                    break;
                }
                case PACKED: {
                    int[] localBuffer = this.currentBuffer;
                    TimestampDictionary localDictionary = this.dictionary;
                    int srcIndex = this.currentBuffer.length - this.currentCount;
                    while (destinationIndex < endIndex) {
                        values[destinationIndex++] = localDictionary.decodeToLong(localBuffer[srcIndex]);
                        ++srcIndex;
                    }
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= numEntriesToFill;
        }
        Preconditions.checkState((remainingToCopy == 0 ? 1 : 0) != 0, (Object)"End of stream: Invalid read size request");
    }

    @Override
    public void skip(int length) throws IOException {
        int remaining;
        int readChunkSize;
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        for (remaining = length; remaining > 0 && (this.currentCount != 0 || this.decode()); remaining -= readChunkSize) {
            readChunkSize = Math.min(remaining, this.currentCount);
            this.currentCount -= readChunkSize;
        }
        Preconditions.checkState((remaining == 0 ? 1 : 0) != 0, (String)"End of stream: Invalid skip size request: %s", (int)length);
    }
}

