/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.GroupField;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.PrimitiveField;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOUtil;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.Type;

public class ColumnIOConverter {
    private ColumnIOConverter() {
    }

    public static Optional<Field> constructField(Type type, ColumnIO columnIO) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = ColumnIOUtil.columnRepetitionLevel((ColumnIO)columnIO);
        int definitionLevel = ColumnIOUtil.columnDefinitionLevel((ColumnIO)columnIO);
        if ("row".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List parameters = type.getTypeParameters();
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = type.getTypeSignature().getParameters();
            boolean structHasParameters = false;
            for (int i = 0; i < fields.size(); ++i) {
                NamedTypeSignature namedTypeSignature = ((TypeSignatureParameter)fields.get(i)).getNamedTypeSignature();
                String name = ((String)namedTypeSignature.getName().get()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = ColumnIOConverter.constructField((Type)parameters.get(i), ParquetTypeUtils.lookupColumnByName(groupColumnIO, name));
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (ImmutableList<Optional<Field>>)fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if ("map".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            MapType mapType = (MapType)type;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn(groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = ColumnIOConverter.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = ColumnIOConverter.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (ImmutableList<Optional<Field>>)ImmutableList.of(keyField, valueField)));
        }
        if ("array".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List types = type.getTypeParameters();
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            Optional<Field> field = ColumnIOConverter.constructField((Type)types.get(0), ParquetTypeUtils.getArrayElementColumn(groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (ImmutableList<Optional<Field>>)ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        RichColumnDescriptor column = new RichColumnDescriptor(primitiveColumnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
        return Optional.of(new PrimitiveField(type, repetitionLevel, definitionLevel, required, column, primitiveColumnIO.getId()));
    }

    public static Optional<ColumnIO> findNestedColumnIO(ColumnIO columnIO, List<String> path) {
        if (columnIO == null) {
            return Optional.empty();
        }
        for (String pathElement : path) {
            if (columnIO instanceof GroupColumnIO) {
                GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
                if ((columnIO = ParquetTypeUtils.lookupColumnByName(groupColumnIO, pathElement)) != null) continue;
                return Optional.empty();
            }
            throw new IllegalArgumentException("Invalid ColumnIO received. Expected a GroupColumnIO, but got " + columnIO.getClass().getSimpleName() + ", path=" + Joiner.on((String)".").join(path));
        }
        return Optional.of(columnIO);
    }
}

