/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InMemoryObjectReadChannel
extends GoogleCloudStorageReadChannel {
    private final byte[] content;

    public InMemoryObjectReadChannel(byte[] content) throws IOException {
        this(content, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public InMemoryObjectReadChannel(byte[] content, GoogleCloudStorageReadOptions readOptions) throws IOException {
        super(readOptions);
        this.content = (byte[])Preconditions.checkNotNull((Object)content, (Object)"channelContents could not be null");
    }

    @Override
    protected InputStream openStream(long bytesToRead) throws IOException {
        if (!this.metadataInitialized && this.content.length == 0 && this.currentPosition == 0L) {
            this.setSize(this.content.length);
        } else {
            this.setSize(this.content.length);
            this.validatePosition(this.currentPosition);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.content);
        ((InputStream)inputStream).skip(this.currentPosition);
        this.contentChannelPosition = this.currentPosition;
        return inputStream;
    }
}

