/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.spi.ConnectorPageSource;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public class BigQueryEmptySplitPageSource
implements ConnectorPageSource {
    private static final Logger log = Logger.get(BigQueryEmptySplitPageSource.class);
    private final long numberOfRows;
    private boolean finished;

    public BigQueryEmptySplitPageSource(long numberOfRows) {
        this.numberOfRows = numberOfRows;
        this.finished = false;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getCompletedPositions() {
        return this.finished ? this.numberOfRows : 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Page getNextPage() {
        log.debug("[%s] creating %d empty rows", new Object[]{Thread.currentThread(), this.numberOfRows});
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of());
        for (long i = 0L; i < this.numberOfRows; ++i) {
            pageBuilder.declarePosition();
        }
        this.finished = true;
        return pageBuilder.build();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

