/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;

public class LookupExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "lookup";
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;

    @Inject
    public LookupExprMacro(LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider) {
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
    }

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() != 2) {
            throw new IAE("Function[%s] must have 2 arguments", new Object[]{this.name()});
        }
        Expr arg = args.get(0);
        Expr lookupExpr = args.get(1);
        if (!lookupExpr.isLiteral() || lookupExpr.getLiteralValue() == null) {
            throw new IAE("Function[%s] second argument must be a registered lookup name", new Object[]{this.name()});
        }
        String lookupName = lookupExpr.getLiteralValue().toString();
        RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(this.lookupExtractorFactoryContainerProvider, lookupName, false, null, false, null);
        class LookupExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ RegisteredLookupExtractionFn val$extractionFn;
            final /* synthetic */ Expr val$lookupExpr;

            LookupExpr(Expr arg) {
                this.val$extractionFn = registeredLookupExtractionFn;
                this.val$lookupExpr = expr;
                super(LookupExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of((String)this.val$extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)this.arg.eval(bindings).asString())));
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new LookupExpr(newArg));
            }

            public String stringify() {
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{LookupExprMacro.FN_NAME, this.arg.stringify(), this.val$lookupExpr.stringify()});
            }
        }
        return new LookupExpr(arg);
    }
}

