/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;

public class RegexpExtractExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "regexp_extract";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        Expr indexExpr;
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", new Object[]{this.name()});
        }
        Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        Expr expr = indexExpr = args.size() > 2 ? args.get(2) : null;
        if (!ExprUtils.isStringLiteral(patternExpr)) {
            throw new IAE("Function[%s] pattern must be a string literal", new Object[]{this.name()});
        }
        if (!(indexExpr == null || indexExpr.isLiteral() && indexExpr.getLiteralValue() instanceof Number)) {
            throw new IAE("Function[%s] index must be a numeric literal", new Object[]{this.name()});
        }
        Pattern pattern = Pattern.compile(StringUtils.nullToEmptyNonDruidDataString((String)((String)patternExpr.getLiteralValue())));
        int index = indexExpr == null ? 0 : ((Number)indexExpr.getLiteralValue()).intValue();
        class RegexpExtractExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ Pattern val$pattern;
            final /* synthetic */ int val$index;
            final /* synthetic */ Expr val$indexExpr;
            final /* synthetic */ Expr val$patternExpr;

            RegexpExtractExpr(Expr arg) {
                this.val$pattern = pattern;
                this.val$index = n;
                this.val$indexExpr = expr;
                this.val$patternExpr = expr2;
                super(RegexpExtractExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String s = NullHandling.nullToEmptyIfNeeded((String)this.arg.eval(bindings).asString());
                if (s == null) {
                    return ExprEval.of(null);
                }
                Matcher matcher = this.val$pattern.matcher(NullHandling.nullToEmptyIfNeeded((String)s));
                String retVal = matcher.find() ? matcher.group(this.val$index) : null;
                return ExprEval.of((String)retVal);
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new RegexpExtractExpr(newArg));
            }

            public String stringify() {
                if (this.val$indexExpr != null) {
                    return StringUtils.format((String)"%s(%s, %s, %s)", (Object[])new Object[]{RegexpExtractExprMacro.FN_NAME, this.arg.stringify(), this.val$patternExpr.stringify(), this.val$indexExpr.stringify()});
                }
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{RegexpExtractExprMacro.FN_NAME, this.arg.stringify(), this.val$patternExpr.stringify()});
            }
        }
        return new RegexpExtractExpr(arg);
    }
}

