/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.DateTime;

public class TimestampCeilExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_ceil";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", new Object[]{this.name()});
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampCeilExpr(args);
        }
        return new TimestampCeilDynamicExpr(args);
    }

    private static PeriodGranularity getGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    @VisibleForTesting
    static class TimestampCeilDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampCeilDynamicExpr(List<Expr> args) {
            super(TimestampCeilExprMacro.FN_NAME, args);
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            DateTime bucketStartTime;
            PeriodGranularity granularity = TimestampCeilExprMacro.getGranularity(this.args, bindings);
            DateTime argTime = DateTimes.utc((long)((Expr)this.args.get(0)).eval(bindings).asLong());
            if (argTime.equals((Object)(bucketStartTime = granularity.bucketStart(argTime)))) {
                return ExprEval.of((long)bucketStartTime.getMillis());
            }
            return ExprEval.of((long)granularity.increment(bucketStartTime).getMillis());
        }

        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit((Expr)new TimestampCeilDynamicExpr(newArgs));
        }
    }

    @VisibleForTesting
    static class TimestampCeilExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Granularity granularity;

        TimestampCeilExpr(List<Expr> args) {
            super(TimestampCeilExprMacro.FN_NAME, args);
            this.granularity = TimestampCeilExprMacro.getGranularity(args, ExprUtils.nilBindings());
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            DateTime bucketStartTime;
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            DateTime argTime = DateTimes.utc((long)eval.asLong());
            if (argTime.equals((Object)(bucketStartTime = this.granularity.bucketStart(argTime)))) {
                return ExprEval.of((long)bucketStartTime.getMillis());
            }
            return ExprEval.of((long)this.granularity.increment(bucketStartTime).getMillis());
        }

        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit((Expr)new TimestampCeilExpr(newArgs));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TimestampCeilExpr that = (TimestampCeilExpr)((Object)o);
            return Objects.equals(this.granularity, that.granularity);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.granularity);
        }
    }
}

