/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;

public abstract class TrimExprMacro
implements ExprMacroTable.ExprMacro {
    private static final char[] EMPTY_CHARS = new char[0];
    private static final char[] DEFAULT_CHARS = new char[]{' '};
    private final TrimMode mode;

    public TrimExprMacro(TrimMode mode) {
        this.mode = mode;
    }

    public String name() {
        return this.mode.getFnName();
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 1 || args.size() > 2) {
            throw new IAE("Function[%s] must have 1 or 2 arguments", new Object[]{this.name()});
        }
        if (args.size() == 1) {
            return new TrimStaticCharsExpr(this.mode, args.get(0), DEFAULT_CHARS, null);
        }
        Expr charsArg = args.get(1);
        if (charsArg.isLiteral()) {
            String charsString = charsArg.eval(ExprUtils.nilBindings()).asString();
            char[] chars = charsString == null ? EMPTY_CHARS : charsString.toCharArray();
            return new TrimStaticCharsExpr(this.mode, args.get(0), chars, charsArg);
        }
        return new TrimDynamicCharsExpr(this.mode, args.get(0), args.get(1));
    }

    private static boolean arrayContains(char[] array, char c) {
        for (char arrayChar : array) {
            if (arrayChar != c) continue;
            return true;
        }
        return false;
    }

    private static boolean stringContains(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static class RightTrimExprMacro
    extends TrimExprMacro {
        public RightTrimExprMacro() {
            super(TrimMode.RIGHT);
        }
    }

    public static class LeftTrimExprMacro
    extends TrimExprMacro {
        public LeftTrimExprMacro() {
            super(TrimMode.LEFT);
        }
    }

    public static class BothTrimExprMacro
    extends TrimExprMacro {
        public BothTrimExprMacro() {
            super(TrimMode.BOTH);
        }
    }

    @VisibleForTesting
    static class TrimDynamicCharsExpr
    implements Expr {
        private final TrimMode mode;
        private final Expr stringExpr;
        private final Expr charsExpr;

        public TrimDynamicCharsExpr(TrimMode mode, Expr stringExpr, Expr charsExpr) {
            this.mode = mode;
            this.stringExpr = stringExpr;
            this.charsExpr = charsExpr;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.stringExpr.eval(bindings);
            if (stringEval.value() == null) {
                return stringEval;
            }
            ExprEval charsEval = this.charsExpr.eval(bindings);
            if (charsEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            String chars = charsEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.stringContains(chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.stringContains(chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of((String)s.substring(start, end));
        }

        public String stringify() {
            return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{this.mode.getFnName(), this.stringExpr.stringify(), this.charsExpr.stringify()});
        }

        public void visit(Expr.Visitor visitor) {
            this.stringExpr.visit(visitor);
            this.charsExpr.visit(visitor);
            visitor.visit((Expr)this);
        }

        public Expr visit(Expr.Shuttle shuttle) {
            Expr newStringExpr = this.stringExpr.visit(shuttle);
            Expr newCharsExpr = this.charsExpr.visit(shuttle);
            return shuttle.visit((Expr)new TrimDynamicCharsExpr(this.mode, newStringExpr, newCharsExpr));
        }

        public Expr.BindingDetails analyzeInputs() {
            return this.stringExpr.analyzeInputs().with(this.charsExpr).withScalarArguments((Set)ImmutableSet.of((Object)this.stringExpr, (Object)this.charsExpr));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrimDynamicCharsExpr that = (TrimDynamicCharsExpr)o;
            return this.mode == that.mode && Objects.equals(this.stringExpr, that.stringExpr) && Objects.equals(this.charsExpr, that.charsExpr);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mode, this.stringExpr, this.charsExpr});
        }
    }

    @VisibleForTesting
    static class TrimStaticCharsExpr
    extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
        private final TrimMode mode;
        private final char[] chars;
        private final Expr charsExpr;

        public TrimStaticCharsExpr(TrimMode mode, Expr stringExpr, char[] chars, Expr charsExpr) {
            super(mode.getFnName(), stringExpr);
            this.mode = mode;
            this.chars = chars;
            this.charsExpr = charsExpr;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.arg.eval(bindings);
            if (this.chars.length == 0 || stringEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.arrayContains(this.chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.arrayContains(this.chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of((String)s.substring(start, end));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            Expr newStringExpr = this.arg.visit(shuttle);
            return shuttle.visit((Expr)new TrimStaticCharsExpr(this.mode, newStringExpr, this.chars, this.charsExpr));
        }

        public String stringify() {
            if (this.charsExpr != null) {
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{this.mode.getFnName(), this.arg.stringify(), this.charsExpr.stringify()});
            }
            return super.stringify();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TrimStaticCharsExpr that = (TrimStaticCharsExpr)((Object)o);
            return this.mode == that.mode && Arrays.equals(this.chars, that.chars) && Objects.equals(this.charsExpr, that.charsExpr);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{super.hashCode(), this.mode, this.charsExpr});
            result = 31 * result + Arrays.hashCode(this.chars);
            return result;
        }
    }

    static enum TrimMode {
        BOTH("trim", true, true),
        LEFT("ltrim", true, false),
        RIGHT("rtrim", false, true);

        private final String name;
        private final boolean left;
        private final boolean right;

        private TrimMode(String name, boolean left, boolean right) {
            this.name = name;
            this.left = left;
            this.right = right;
        }

        public String getFnName() {
            return this.name;
        }

        public boolean isLeft() {
            return this.left;
        }

        public boolean isRight() {
            return this.right;
        }
    }
}

