/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.VirtualColumns;

@JsonTypeName(value="timeseries")
public class TimeseriesQuery
extends BaseQuery<Result<TimeseriesResultValue>> {
    public static final String CTX_GRAND_TOTAL = "grandTotal";
    public static final String SKIP_EMPTY_BUCKETS = "skipEmptyBuckets";
    public static final String CTX_TIMESTAMP_RESULT_FIELD = "timestampResultField";
    private final VirtualColumns virtualColumns;
    private final DimFilter dimFilter;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;
    private final int limit;

    @JsonCreator
    public TimeseriesQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="descending") boolean descending, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="limit") int limit, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, descending, context, granularity);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimFilter = dimFilter;
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = Queries.prepareAggregations((List<String>)ImmutableList.of(), this.aggregatorSpecs, (List<PostAggregator>)(postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs));
        this.limit = limit == 0 ? Integer.MAX_VALUE : limit;
        Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater than 0");
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "timeseries";
    }

    @Override
    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @JsonProperty(value="limit")
    public int getLimit() {
        return this.limit;
    }

    public boolean isGrandTotal() {
        return this.getContextBoolean(CTX_GRAND_TOTAL, false);
    }

    public String getTimestampResultField() {
        return (String)this.getContextValue(CTX_TIMESTAMP_RESULT_FIELD);
    }

    public boolean isSkipEmptyBuckets() {
        return this.getContextBoolean(SKIP_EMPTY_BUCKETS, false);
    }

    public TimeseriesQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return Druids.TimeseriesQueryBuilder.copy(this).intervals(querySegmentSpec).build();
    }

    @Override
    public Query<Result<TimeseriesResultValue>> withDataSource(DataSource dataSource) {
        return Druids.TimeseriesQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    @Override
    public Query<Result<TimeseriesResultValue>> optimizeForSegment(PerSegmentQueryOptimizationContext optimizationContext) {
        return Druids.TimeseriesQueryBuilder.copy(this).aggregators(this.optimizeAggs(optimizationContext)).build();
    }

    public TimeseriesQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        Map<String, Object> newContext = TimeseriesQuery.computeOverriddenContext(this.getContext(), contextOverrides);
        return Druids.TimeseriesQueryBuilder.copy(this).context(newContext).build();
    }

    public TimeseriesQuery withDimFilter(DimFilter dimFilter) {
        return Druids.TimeseriesQueryBuilder.copy(this).filters(dimFilter).build();
    }

    public TimeseriesQuery withPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
        return Druids.TimeseriesQueryBuilder.copy(this).postAggregators(postAggregatorSpecs).build();
    }

    private List<AggregatorFactory> optimizeAggs(PerSegmentQueryOptimizationContext optimizationContext) {
        ArrayList<AggregatorFactory> optimizedAggs = new ArrayList<AggregatorFactory>();
        for (AggregatorFactory aggregatorFactory : this.aggregatorSpecs) {
            optimizedAggs.add(aggregatorFactory.optimizeForSegment(optimizationContext));
        }
        return optimizedAggs;
    }

    public String toString() {
        return "TimeseriesQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", descending=" + this.isDescending() + ", virtualColumns=" + this.virtualColumns + ", dimFilter=" + this.dimFilter + ", granularity='" + this.getGranularity() + '\'' + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", limit=" + this.limit + ", context=" + this.getContext() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeseriesQuery that = (TimeseriesQuery)o;
        return this.limit == that.limit && Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.dimFilter, that.dimFilter) && Objects.equals(this.aggregatorSpecs, that.aggregatorSpecs) && Objects.equals(this.postAggregatorSpecs, that.postAggregatorSpecs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.virtualColumns, this.dimFilter, this.aggregatorSpecs, this.postAggregatorSpecs, this.limit);
    }
}

