/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.virtual.ExpressionSelectors;

public class ExpressionFilter
implements Filter {
    private final Supplier<Expr> expr;
    private final Supplier<Set<String>> requiredBindings;
    private final FilterTuning filterTuning;

    public ExpressionFilter(Supplier<Expr> expr, FilterTuning filterTuning) {
        this.expr = expr;
        this.requiredBindings = Suppliers.memoize(() -> ((Expr)expr.get()).analyzeInputs().getRequiredBindings());
        this.filterTuning = filterTuning;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ColumnValueSelector<ExprEval> selector = ExpressionSelectors.makeExprEvalSelector(factory, (Expr)this.expr.get());
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                ExprEval eval = (ExprEval)selector.getObject();
                switch (eval.type()) {
                    case LONG_ARRAY: {
                        Long[] lResult = eval.asLongArray();
                        if (lResult == null) {
                            return false;
                        }
                        return Arrays.stream(lResult).anyMatch(Evals::asBoolean);
                    }
                    case STRING_ARRAY: {
                        String[] sResult = eval.asStringArray();
                        if (sResult == null) {
                            return false;
                        }
                        return Arrays.stream(sResult).anyMatch(Evals::asBoolean);
                    }
                    case DOUBLE_ARRAY: {
                        Double[] dResult = eval.asDoubleArray();
                        if (dResult == null) {
                            return false;
                        }
                        return Arrays.stream(dResult).anyMatch(Evals::asBoolean);
                    }
                }
                return eval.asBoolean();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        if (((Set)this.requiredBindings.get()).isEmpty()) {
            return true;
        }
        if (((Set)this.requiredBindings.get()).size() == 1) {
            String column = (String)Iterables.getOnlyElement((Iterable)((Iterable)this.requiredBindings.get()));
            return selector.getBitmapIndex(column) != null && !selector.hasMultipleValues(column).isMaybeTrue();
        }
        return false;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (((Set)this.requiredBindings.get()).isEmpty()) {
            if (((Expr)this.expr.get()).eval(ExprUtils.nilBindings()).asBoolean()) {
                return bitmapResultFactory.wrapAllTrue(Filters.allTrue(selector));
            }
            return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
        }
        String column = (String)Iterables.getOnlyElement((Iterable)((Iterable)this.requiredBindings.get()));
        return Filters.matchPredicate(column, selector, bitmapResultFactory, (Predicate<String>)((Predicate)value -> ((Expr)this.expr.get()).eval(identifierName -> {
            assert (column.equals(identifierName));
            return NullHandling.nullToEmptyIfNeeded((String)value);
        }).asBoolean()));
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return false;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getRequiredColumns() {
        return (Set)this.requiredBindings.get();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionFilter that = (ExpressionFilter)o;
        return Objects.equals(this.expr, that.expr) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.expr, this.filterTuning);
    }

    public String toString() {
        return "ExpressionFilter{expr=" + this.expr + ", requiredBindings=" + this.requiredBindings + ", filterTuning=" + this.filterTuning + '}';
    }
}

