/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.inject.Inject;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;

public class MapJoinableFactory
implements JoinableFactory {
    private final Map<Class<? extends DataSource>, JoinableFactory> joinableFactories;

    @Inject
    public MapJoinableFactory(Map<Class<? extends DataSource>, JoinableFactory> joinableFactories) {
        this.joinableFactories = new IdentityHashMap<Class<? extends DataSource>, JoinableFactory>(joinableFactories);
    }

    @Override
    public boolean isDirectlyJoinable(DataSource dataSource) {
        JoinableFactory factory = this.joinableFactories.get(dataSource.getClass());
        if (factory == null) {
            return false;
        }
        return factory.isDirectlyJoinable(dataSource);
    }

    @Override
    public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
        JoinableFactory factory = this.joinableFactories.get(dataSource.getClass());
        if (factory == null) {
            return Optional.empty();
        }
        return factory.build(dataSource, condition);
    }
}

