/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.CassandraTypeWithTypeArguments;
import com.facebook.presto.cassandra.FullCassandraType;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class CassandraColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String name;
    private final int ordinalPosition;
    private final CassandraType cassandraType;
    private final List<CassandraType> typeArguments;
    private final boolean partitionKey;
    private final boolean clusteringKey;
    private final boolean indexed;
    private final boolean hidden;

    @JsonCreator
    public CassandraColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="cassandraType") CassandraType cassandraType, @Nullable @JsonProperty(value="typeArguments") List<CassandraType> typeArguments, @JsonProperty(value="partitionKey") boolean partitionKey, @JsonProperty(value="clusteringKey") boolean clusteringKey, @JsonProperty(value="indexed") boolean indexed, @JsonProperty(value="hidden") boolean hidden) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((ordinalPosition >= 0 ? 1 : 0) != 0, (Object)"ordinalPosition is negative");
        this.ordinalPosition = ordinalPosition;
        this.cassandraType = Objects.requireNonNull(cassandraType, "cassandraType is null");
        int typeArgsSize = cassandraType.getTypeArgumentSize();
        if (typeArgsSize > 0) {
            this.typeArguments = Objects.requireNonNull(typeArguments, "typeArguments is null");
            Preconditions.checkArgument((typeArguments.size() == typeArgsSize ? 1 : 0) != 0, (Object)(cassandraType + " must provide " + typeArgsSize + " type arguments"));
        } else {
            this.typeArguments = null;
        }
        this.partitionKey = partitionKey;
        this.clusteringKey = clusteringKey;
        this.indexed = indexed;
        this.hidden = hidden;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public CassandraType getCassandraType() {
        return this.cassandraType;
    }

    @JsonProperty
    public List<CassandraType> getTypeArguments() {
        return this.typeArguments;
    }

    @JsonProperty
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    @JsonProperty
    public boolean isClusteringKey() {
        return this.clusteringKey;
    }

    @JsonProperty
    public boolean isIndexed() {
        return this.indexed;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(CassandraCqlUtils.cqlNameToSqlName(this.name), this.cassandraType.getNativeType(), null, this.hidden);
    }

    public Type getType() {
        return this.cassandraType.getNativeType();
    }

    public FullCassandraType getFullType() {
        if (this.cassandraType.getTypeArgumentSize() == 0) {
            return this.cassandraType;
        }
        return new CassandraTypeWithTypeArguments(this.cassandraType, this.typeArguments);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.name, this.ordinalPosition, this.cassandraType, this.typeArguments, this.partitionKey, this.clusteringKey, this.indexed, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraColumnHandle other = (CassandraColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.name, other.name) && Objects.equals(this.ordinalPosition, other.ordinalPosition) && Objects.equals(this.cassandraType, other.cassandraType) && Objects.equals(this.typeArguments, other.typeArguments) && Objects.equals(this.partitionKey, other.partitionKey) && Objects.equals(this.clusteringKey, other.clusteringKey) && Objects.equals(this.indexed, other.indexed) && Objects.equals(this.hidden, other.hidden);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("name", (Object)this.name).add("ordinalPosition", this.ordinalPosition).add("cassandraType", (Object)this.cassandraType);
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            helper.add("typeArguments", this.typeArguments);
        }
        helper.add("partitionKey", this.partitionKey).add("clusteringKey", this.clusteringKey).add("indexed", this.indexed).add("hidden", this.hidden);
        return helper.toString();
    }
}

