/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import io.airlift.slice.Slice;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class CassandraPageSink
implements ConnectorPageSink {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneId.of("UTC"));
    private final CassandraSession cassandraSession;
    private final PreparedStatement insert;
    private final List<Type> columnTypes;
    private final boolean generateUUID;
    private final Function<Long, Object> toCassandraDate;

    public CassandraPageSink(CassandraSession cassandraSession, ProtocolVersion protocolVersion, String schemaName, String tableName, List<String> columnNames, List<Type> columnTypes, boolean generateUUID) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.generateUUID = generateUUID;
        this.toCassandraDate = protocolVersion.toInt() <= ProtocolVersion.V3.toInt() ? value -> DATE_FORMATTER.format(Instant.ofEpochMilli(TimeUnit.DAYS.toMillis((long)value))) : value -> LocalDate.fromDaysSinceEpoch((int)Math.toIntExact(value));
        Insert insert = QueryBuilder.insertInto((String)schemaName, (String)tableName);
        if (generateUUID) {
            insert.value("id", (Object)QueryBuilder.bindMarker());
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            Preconditions.checkArgument((columnName != null ? 1 : 0) != 0, (String)"columnName is null at position: %d", (int)i);
            insert.value(columnName, (Object)QueryBuilder.bindMarker());
        }
        this.insert = cassandraSession.prepare((RegularStatement)insert);
    }

    public CompletableFuture<?> appendPage(Page page) {
        for (int position = 0; position < page.getPositionCount(); ++position) {
            ArrayList<Object> values = new ArrayList<Object>(this.columnTypes.size() + 1);
            if (this.generateUUID) {
                values.add(UUID.randomUUID());
            }
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                this.appendColumn(values, page, position, channel);
            }
            this.cassandraSession.execute((Statement)this.insert.bind(values.toArray()));
        }
        return NOT_BLOCKED;
    }

    private void appendColumn(List<Object> values, Page page, int position, int channel) {
        Block block = page.getBlock(channel);
        Type type = this.columnTypes.get(channel);
        if (block.isNull(position)) {
            values.add(null);
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            values.add(type.getBoolean(block, position));
        } else if (BigintType.BIGINT.equals((Object)type)) {
            values.add(type.getLong(block, position));
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            values.add(Math.toIntExact(type.getLong(block, position)));
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            values.add(Shorts.checkedCast((long)type.getLong(block, position)));
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            values.add((byte)type.getLong(block, position));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            values.add(type.getDouble(block, position));
        } else if (RealType.REAL.equals((Object)type)) {
            values.add(Float.valueOf(Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position)))));
        } else if (DateType.DATE.equals((Object)type)) {
            values.add(this.toCassandraDate.apply(type.getLong(block, position)));
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            values.add(new Timestamp(type.getLong(block, position)));
        } else if (Varchars.isVarcharType((Type)type)) {
            values.add(type.getSlice(block, position).toStringUtf8());
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            values.add(type.getSlice(block, position).toByteBuffer());
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

