/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.VersionNumber;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.SizeEstimate;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;

public interface CassandraSession {
    public static final String PRESTO_COMMENT_METADATA = "Presto Metadata:";

    public VersionNumber getCassandraVersion();

    public String getPartitioner();

    public Set<TokenRange> getTokenRanges();

    public Set<Host> getReplicas(String var1, TokenRange var2);

    public Set<Host> getReplicas(String var1, ByteBuffer var2);

    public String getCaseSensitiveSchemaName(String var1);

    public List<String> getCaseSensitiveSchemaNames();

    public List<String> getCaseSensitiveTableNames(String var1) throws SchemaNotFoundException;

    public CassandraTable getTable(SchemaTableName var1) throws TableNotFoundException;

    public List<CassandraPartition> getPartitions(CassandraTable var1, List<Set<Object>> var2);

    public boolean isMaterializedView(SchemaTableName var1);

    public ResultSet execute(String var1, Object ... var2);

    public List<SizeEstimate> getSizeEstimates(String var1, String var2);

    public PreparedStatement prepare(RegularStatement var1);

    public ResultSet execute(Statement var1);
}

