/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.json.AbstractDateTimeJsonValueProvider;
import com.facebook.presto.decoder.json.JsonFieldDecoder;
import com.facebook.presto.decoder.json.JsonRowDecoderFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RFC2822JsonFieldDecoder
implements JsonFieldDecoder {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)DateType.DATE, (Object)TimeType.TIME, (Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)TimestampType.TIMESTAMP, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.ENGLISH).withZoneUTC();
    private final DecoderColumnHandle columnHandle;

    public RFC2822JsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!SUPPORTED_TYPES.contains(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new RFC2822JsonValueProvider(value, this.columnHandle);
    }

    public static class RFC2822JsonValueProvider
    extends AbstractDateTimeJsonValueProvider {
        public RFC2822JsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        protected long getMillis() {
            if (this.value.isValueNode()) {
                try {
                    return FORMATTER.parseMillis(this.value.asText());
                }
                catch (IllegalArgumentException e) {
                    throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
                }
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", this.columnHandle.getType(), this.columnHandle.getName()));
        }
    }
}

