/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.GenericInternalException;
import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.reader.SliceSelectiveStreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class SliceDirectSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDirectSelectiveStreamReader.class).instanceSize();
    private static final int ONE_GIGABYTE = Math.toIntExact(new DataSize(1.0, DataSize.Unit.GIGABYTE).toBytes());
    private final TupleDomainFilter filter;
    private final boolean nonDeterministicFilter;
    private final boolean nullsAllowed;
    private final StreamDescriptor streamDescriptor;
    private final boolean outputRequired;
    private final Type outputType;
    private final boolean isCharType;
    private final int maxCodePointCount;
    private int readOffset;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteArrayInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private ByteArrayInputStream dataStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;
    private OrcLocalMemoryContext systemMemoryContext;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private boolean[] isNullVector;
    private int[] lengthVector;
    private int lengthIndex;
    private int[] offsets;
    private byte[] data;
    private Slice dataAsSlice;
    private boolean valuesInUse;

    public SliceDirectSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, OrcLocalMemoryContext newLocalMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = Objects.requireNonNull(filter, "filter is null").orElse(null);
        this.systemMemoryContext = newLocalMemoryContext;
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
        this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
        this.outputRequired = outputType.isPresent();
        this.isCharType = streamDescriptor.getOrcType().getOrcTypeKind() == OrcType.OrcTypeKind.CHAR;
        this.maxCodePointCount = streamDescriptor.getOrcType().getLength().orElse(-1);
        Preconditions.checkArgument((filter.isPresent() || this.outputRequired ? 1 : 0) != 0, (Object)"filter must be present if outputRequired is false");
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int dataLength = this.prepareForNextRead(positionCount, positions);
        int streamPosition = this.lengthStream == null ? this.readAllNulls(positions, positionCount) : (this.filter == null ? this.readNoFilter(positions, positionCount, dataLength) : this.readWithFilter(positions, positionCount, dataLength));
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readNoFilter(int[] positions, int positionCount, int dataLength) throws IOException {
        int totalPositionCount = positions[positionCount - 1] + 1;
        if (this.useBatchMode(positionCount, totalPositionCount)) {
            if (this.presentStream == null) {
                if (this.dataStream != null) {
                    this.dataStream.next(this.data, 0, dataLength);
                    ReaderUtils.convertLengthVectorToOffsetVector(this.lengthVector, totalPositionCount, this.offsets);
                    if (totalPositionCount > positionCount) {
                        ReaderUtils.packByteArrayAndOffsets(this.data, this.offsets, positions, positionCount);
                    }
                }
            } else {
                if (this.dataStream != null) {
                    this.dataStream.next(this.data, 0, dataLength);
                    ReaderUtils.convertLengthVectorToOffsetVector(this.lengthVector, this.isNullVector, totalPositionCount, this.offsets);
                }
                if (totalPositionCount > positionCount) {
                    ReaderUtils.packByteArrayOffsetsAndNulls(this.data, this.offsets, this.isNullVector, positions, positionCount);
                }
                if (this.nullsAllowed) {
                    System.arraycopy(this.isNullVector, 0, this.nulls, 0, positionCount);
                }
            }
            this.outputPositionCount = positionCount;
            return totalPositionCount;
        }
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skipData(streamPosition, position - streamPosition);
                streamPosition = position;
            }
            int offset = this.offsets[i];
            if (this.presentStream != null && this.isNullVector[position]) {
                if (this.offsets != null) {
                    this.offsets[i + 1] = offset;
                }
                this.nulls[i] = true;
            } else {
                int length = this.lengthVector[this.lengthIndex];
                int truncatedLength = 0;
                if (length > 0) {
                    this.dataStream.next(this.data, offset, offset + length);
                    truncatedLength = SliceSelectiveStreamReader.computeTruncatedLength(this.dataAsSlice, offset, length, this.maxCodePointCount, this.isCharType);
                }
                this.offsets[i + 1] = offset + truncatedLength;
                ++this.lengthIndex;
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount, int dataLength) throws IOException {
        int totalPositionCount = positions[positionCount - 1] + 1;
        if (this.useBatchMode(positionCount, totalPositionCount)) {
            int filteredPositionCount;
            if (this.dataStream != null) {
                this.dataStream.next(this.data, 0, dataLength);
            }
            if (this.presentStream == null) {
                filteredPositionCount = this.evaluateFilter(positions, positionCount);
                if (this.outputRequired && totalPositionCount > filteredPositionCount && filteredPositionCount > 0 && this.dataStream != null) {
                    ReaderUtils.packByteArrayAndOffsets(this.data, this.offsets, this.outputPositions, filteredPositionCount);
                }
            } else {
                filteredPositionCount = this.evaluateFilterWithNull(positions, positionCount);
                if (this.outputRequired && filteredPositionCount > 0) {
                    if (this.outputRequired && totalPositionCount > filteredPositionCount) {
                        ReaderUtils.packByteArrayOffsetsAndNulls(this.data, this.offsets, this.isNullVector, this.outputPositions, filteredPositionCount);
                    }
                    if (this.nullsAllowed) {
                        System.arraycopy(this.isNullVector, 0, this.nulls, 0, filteredPositionCount);
                    }
                }
            }
            this.outputPositionCount = filteredPositionCount;
            return totalPositionCount;
        }
        int streamPosition = 0;
        int dataToSkip = 0;
        for (int i = 0; i < positionCount; ++i) {
            int offset;
            int position = positions[i];
            if (position > streamPosition) {
                this.skipData(streamPosition, position - streamPosition);
                streamPosition = position;
            }
            int n = offset = this.outputRequired ? this.offsets[this.outputPositionCount] : 0;
            if (this.presentStream != null && this.isNullVector[position]) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.offsets[this.outputPositionCount + 1] = offset;
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int dataOffset;
                int length = this.lengthVector[this.lengthIndex];
                int n2 = dataOffset = this.outputRequired ? offset : 0;
                if (this.filter.testLength(length)) {
                    if (this.dataStream != null) {
                        this.dataStream.skip(dataToSkip);
                        dataToSkip = 0;
                        this.dataStream.next(this.data, dataOffset, dataOffset + length);
                        if (this.filter.testBytes(this.data, dataOffset, length)) {
                            if (this.outputRequired) {
                                int truncatedLength = SliceSelectiveStreamReader.computeTruncatedLength(this.dataAsSlice, dataOffset, length, this.maxCodePointCount, this.isCharType);
                                this.offsets[this.outputPositionCount + 1] = offset + truncatedLength;
                                if (this.nullsAllowed && this.presentStream != null) {
                                    this.nulls[this.outputPositionCount] = false;
                                }
                            }
                            this.outputPositions[this.outputPositionCount] = position;
                            ++this.outputPositionCount;
                        }
                    } else {
                        assert (length == 0);
                        if (this.filter.testBytes("".getBytes(), 0, 0)) {
                            if (this.outputRequired) {
                                this.offsets[this.outputPositionCount + 1] = offset;
                                if (this.nullsAllowed && this.presentStream != null) {
                                    this.nulls[this.outputPositionCount] = false;
                                }
                            }
                            this.outputPositions[this.outputPositionCount] = position;
                            ++this.outputPositionCount;
                        }
                    }
                } else {
                    dataToSkip += length;
                }
                ++this.lengthIndex;
            }
            ++streamPosition;
            if (this.filter == null) continue;
            this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
            int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            this.skipData(streamPosition, positionsToSkip);
        }
        if (dataToSkip > 0) {
            this.dataStream.skip(dataToSkip);
        }
        return streamPosition;
    }

    private int readAllNulls(int[] positions, int positionCount) {
        if (this.nonDeterministicFilter) {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                if (this.filter.testNull()) {
                    ++this.outputPositionCount;
                    continue;
                }
                this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
                i += this.filter.getSucceedingPositionsToFail();
            }
        } else {
            this.outputPositionCount = this.nullsAllowed ? positionCount : 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null && this.presentStream != null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int lengthToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(this.lengthStream.sum(lengthToSkip));
        } else {
            long sum = this.lengthStream.sum(items);
            if (this.dataStream != null) {
                this.dataStream.skip(sum);
            }
        }
    }

    private void skipData(int start, int items) throws IOException {
        int dataToSkip = 0;
        for (int i = 0; i < items; ++i) {
            if (this.presentStream != null && this.isNullVector[start + i]) continue;
            dataToSkip += this.lengthVector[this.lengthIndex];
            ++this.lengthIndex;
        }
        if (this.dataStream != null) {
            this.dataStream.skip(dataToSkip);
        }
    }

    private int evaluateFilter(int[] positions, int positionCount) {
        int positionsIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (this.filter.testLength(this.lengthVector[position])) {
                this.outputPositions[positionsIndex++] = position;
                continue;
            }
            i += this.filter.getSucceedingPositionsToFail();
            positionsIndex -= this.filter.getPrecedingPositionsToFail();
        }
        int filteredPositionCount = 0;
        if (positionsIndex > 0) {
            if (this.dataStream == null) {
                filteredPositionCount = this.testEmptyStrings(this.outputPositions, positionsIndex);
            } else {
                int totalPositionCount = this.outputPositions[positionsIndex - 1] + 1;
                ReaderUtils.convertLengthVectorToOffsetVector(this.lengthVector, totalPositionCount, this.offsets);
                filteredPositionCount = this.testBytes(this.outputPositions, positionsIndex);
            }
        }
        return filteredPositionCount;
    }

    private int evaluateFilterWithNull(int[] positions, int positionCount) {
        if (this.dataStream != null) {
            int totalPositionCount = positions[positionCount - 1] + 1;
            ReaderUtils.convertLengthVectorToOffsetVector(this.lengthVector, this.isNullVector, totalPositionCount, this.offsets);
        }
        int positionsIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (this.isNullVector[position]) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    this.outputPositions[positionsIndex++] = position;
                    continue;
                }
                i += this.filter.getSucceedingPositionsToFail();
                positionsIndex -= this.filter.getPrecedingPositionsToFail();
                continue;
            }
            int dataOffset = this.offsets[position];
            int length = this.offsets[position + 1] - dataOffset;
            if (this.filter.testLength(length) && this.filter.testBytes(this.data, dataOffset, length)) {
                this.outputPositions[positionsIndex++] = position;
                continue;
            }
            i += this.filter.getSucceedingPositionsToFail();
            positionsIndex -= this.filter.getPrecedingPositionsToFail();
        }
        return positionsIndex;
    }

    private int testEmptyStrings(int[] positions, int positionCount) {
        if (this.nonDeterministicFilter) {
            int positionsIndex = 0;
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (this.filter.testBytes("".getBytes(), 0, 0)) {
                    positions[positionsIndex++] = position;
                    continue;
                }
                i += this.filter.getSucceedingPositionsToFail();
                positionsIndex -= this.filter.getPrecedingPositionsToFail();
            }
            return positionsIndex;
        }
        if (this.filter.testBytes("".getBytes(), 0, 0)) {
            return positionCount;
        }
        return 0;
    }

    private int testBytes(int[] positions, int positionCount) {
        int positionsIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            int dataOffset = this.offsets[position];
            int length = this.offsets[position + 1] - dataOffset;
            if (this.filter.testBytes(this.data, dataOffset, length)) {
                positions[positionsIndex++] = position;
                continue;
            }
            i += this.filter.getSucceedingPositionsToFail();
            positionsIndex -= this.filter.getPrecedingPositionsToFail();
        }
        return positionsIndex;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        VariableWidthBlock block = new VariableWidthBlock(positionCount, this.dataAsSlice, this.offsets, Optional.ofNullable(includeNulls ? this.nulls : null));
        this.dataAsSlice = null;
        this.data = null;
        this.offsets = null;
        this.nulls = null;
        return block;
    }

    private void compactValues(int[] positions, int positionCount, boolean includeNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            int length = this.offsets[i + 1] - this.offsets[i];
            if (length > 0) {
                System.arraycopy(this.data, this.offsets[i], this.data, this.offsets[positionIndex], length);
            }
            this.offsets[positionIndex + 1] = this.offsets[positionIndex] + length;
            this.outputPositions[positionIndex] = nextPosition;
            if (includeNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount));
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        return this.newLease((Block)new VariableWidthBlock(positionCount, this.dataAsSlice, this.offsets, Optional.ofNullable(includeNulls ? this.nulls : null)));
    }

    private BlockLease newLease(Block block) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            this.valuesInUse = false;
        }});
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    @Override
    public void close() {
        this.dataAsSlice = null;
        this.data = null;
        this.lengthVector = null;
        this.isNullVector = null;
        this.offsets = null;
        this.outputPositions = null;
        this.systemMemoryContext.close();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(Stripe stripe) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((byte[])this.data) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.lengthVector) + SizeOf.sizeOf((boolean[])this.isNullVector);
    }

    @VisibleForTesting
    public void resetDataStream() {
        this.dataStream = null;
    }

    private int prepareForNextRead(int positionCount, int[] positions) throws IOException {
        this.lengthIndex = 0;
        this.outputPositionCount = 0;
        int totalLength = 0;
        int maxLength = 0;
        int dataLength = 0;
        int totalPositions = positions[positionCount - 1] + 1;
        int nullCount = 0;
        if (this.presentStream != null) {
            this.isNullVector = Arrays.ensureCapacity((boolean[])this.isNullVector, (int)totalPositions);
            nullCount = this.presentStream.getUnsetBits(totalPositions, this.isNullVector);
        }
        if (this.lengthStream != null) {
            int nonNullCount = totalPositions - nullCount;
            this.lengthVector = Arrays.ensureCapacity((int[])this.lengthVector, (int)nonNullCount);
            this.lengthStream.next(this.lengthVector, nonNullCount);
            if (this.useBatchMode(positionCount, totalPositions)) {
                for (int i = 0; i < nonNullCount; ++i) {
                    totalLength += this.lengthVector[i];
                    maxLength = Math.max(maxLength, this.lengthVector[i]);
                }
            } else {
                int positionIndex = 0;
                int lengthIndex = 0;
                for (int i = 0; i < totalPositions; ++i) {
                    boolean isNotNull;
                    boolean bl = isNotNull = nullCount == 0 || !this.isNullVector[i];
                    if (i == positions[positionIndex]) {
                        if (isNotNull) {
                            totalLength += this.lengthVector[lengthIndex];
                            maxLength = Math.max(maxLength, this.lengthVector[lengthIndex]);
                            ++lengthIndex;
                        }
                        ++positionIndex;
                        continue;
                    }
                    if (!isNotNull) continue;
                    ++lengthIndex;
                }
            }
            if (totalLength > ONE_GIGABYTE) {
                throw new GenericInternalException(String.format("Values in column \"%s\" are too large to process for Presto. %s column values are larger than 1GB [%s]", this.streamDescriptor.getFieldName(), positionCount, this.streamDescriptor.getOrcDataSourceId()));
            }
        }
        if (this.outputRequired) {
            if (this.presentStream != null && this.nullsAllowed) {
                this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)positionCount);
            }
            dataLength = totalLength;
            this.data = Arrays.ensureCapacity((byte[])this.data, (int)totalLength);
            this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(totalPositions + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.INITIALIZE);
        } else {
            if (this.useBatchMode(positionCount, totalPositions)) {
                dataLength = totalLength;
                if (this.filter != null) {
                    this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(totalPositions + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.INITIALIZE);
                }
            } else {
                dataLength = maxLength;
            }
            this.data = Arrays.ensureCapacity((byte[])this.data, (int)dataLength);
        }
        this.dataAsSlice = Slices.wrappedBuffer((byte[])this.data);
        return dataLength;
    }

    private boolean useBatchMode(int positionCount, int totalPositionCount) {
        if (this.lengthStream == null || this.maxCodePointCount >= 0) {
            return false;
        }
        double inputFilterRate = (double)(totalPositionCount - positionCount) / (double)totalPositionCount;
        if (this.filter == null) {
            return inputFilterRate >= 0.0 && inputFilterRate <= 0.5;
        }
        return inputFilterRate >= 0.0 && inputFilterRate <= (double)0.05f || inputFilterRate >= (double)0.15f && inputFilterRate <= 0.5;
    }
}

