/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.stream.ByteInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class BooleanInputStream
implements ValueInputStream<BooleanStreamCheckpoint> {
    private static final int HIGH_BIT_MASK = 128;
    private final ByteInputStream byteStream;
    private byte data;
    private int bitsInData;

    public BooleanInputStream(OrcInputStream byteStream) {
        this.byteStream = new ByteInputStream(byteStream);
    }

    private void readByte() throws IOException {
        Preconditions.checkState((this.bitsInData == 0 ? 1 : 0) != 0);
        this.data = this.byteStream.next();
        this.bitsInData = 8;
    }

    public boolean nextBit() throws IOException {
        if (this.bitsInData == 0) {
            this.readByte();
        }
        boolean result = (this.data & 0x80) != 0;
        this.data = (byte)(this.data << 1);
        --this.bitsInData;
        return result;
    }

    @Override
    public Class<BooleanStreamCheckpoint> getCheckpointType() {
        return BooleanStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(BooleanStreamCheckpoint checkpoint) throws IOException {
        this.byteStream.seekToCheckpoint(checkpoint.getByteStreamCheckpoint());
        this.bitsInData = 0;
        this.skip(checkpoint.getOffset());
    }

    @Override
    public void skip(long items) throws IOException {
        if ((long)this.bitsInData >= items) {
            this.data = (byte)(this.data << (int)items);
            this.bitsInData = (int)((long)this.bitsInData - items);
        } else {
            this.bitsInData = 0;
            this.byteStream.skip((items -= (long)this.bitsInData) >>> 3);
            if ((items &= 7L) != 0L) {
                this.readByte();
                this.data = (byte)(this.data << (int)items);
                this.bitsInData = (int)((long)this.bitsInData - items);
            }
        }
    }

    public int countBitsSet(int items) throws IOException {
        int count = 0;
        if (items > this.bitsInData && this.bitsInData > 0) {
            count += BooleanInputStream.bitCount(this.data);
            items -= this.bitsInData;
            this.bitsInData = 0;
        }
        while (items > 8) {
            count += BooleanInputStream.bitCount(this.byteStream.next());
            items -= 8;
        }
        for (int i = 0; i < items; ++i) {
            count += this.nextBit() ? 1 : 0;
        }
        return count;
    }

    public byte[] getSetBits(int batchSize) throws IOException {
        byte[] vector = new byte[batchSize];
        this.getSetBits(batchSize, vector);
        return vector;
    }

    public void getSetBits(int batchSize, byte[] vector) throws IOException {
        int value;
        int offset = 0;
        int count = Math.min(batchSize, this.bitsInData);
        if (count != 0) {
            value = this.data >>> 8 - count;
            switch (count) {
                case 7: {
                    vector[offset++] = (byte)((value & 0x40) >>> 6);
                }
                case 6: {
                    vector[offset++] = (byte)((value & 0x20) >>> 5);
                }
                case 5: {
                    vector[offset++] = (byte)((value & 0x10) >>> 4);
                }
                case 4: {
                    vector[offset++] = (byte)((value & 8) >>> 3);
                }
                case 3: {
                    vector[offset++] = (byte)((value & 4) >>> 2);
                }
                case 2: {
                    vector[offset++] = (byte)((value & 2) >>> 1);
                }
                case 1: {
                    vector[offset++] = (byte)((value & 1) >>> 0);
                }
            }
            this.data = (byte)(this.data << count);
            this.bitsInData -= count;
            if (count == batchSize) {
                return;
            }
        }
        while (offset < batchSize - 7) {
            value = this.byteStream.next();
            vector[offset + 0] = (byte)((value & 0x80) >>> 7);
            vector[offset + 1] = (byte)((value & 0x40) >>> 6);
            vector[offset + 2] = (byte)((value & 0x20) >>> 5);
            vector[offset + 3] = (byte)((value & 0x10) >>> 4);
            vector[offset + 4] = (byte)((value & 8) >>> 3);
            vector[offset + 5] = (byte)((value & 4) >>> 2);
            vector[offset + 6] = (byte)((value & 2) >>> 1);
            vector[offset + 7] = (byte)(value & 1);
            offset += 8;
        }
        int remaining = batchSize - offset;
        if (remaining > 0) {
            byte data = this.byteStream.next();
            int value2 = data >>> 8 - remaining;
            switch (remaining) {
                case 7: {
                    vector[offset++] = (byte)((value2 & 0x40) >>> 6);
                }
                case 6: {
                    vector[offset++] = (byte)((value2 & 0x20) >>> 5);
                }
                case 5: {
                    vector[offset++] = (byte)((value2 & 0x10) >>> 4);
                }
                case 4: {
                    vector[offset++] = (byte)((value2 & 8) >>> 3);
                }
                case 3: {
                    vector[offset++] = (byte)((value2 & 4) >>> 2);
                }
                case 2: {
                    vector[offset++] = (byte)((value2 & 2) >>> 1);
                }
                case 1: {
                    vector[offset++] = (byte)((value2 & 1) >>> 0);
                }
            }
            this.data = (byte)(data << remaining);
            this.bitsInData = 8 - remaining;
        }
    }

    public int getSetBits(int batchSize, boolean[] vector) throws IOException {
        int value;
        int offset = 0;
        int countBitsSet = 0;
        int count = Math.min(batchSize, this.bitsInData);
        if (count != 0) {
            value = (this.data & 0xFF) >>> 8 - count;
            countBitsSet += Integer.bitCount(value);
            switch (count) {
                case 7: {
                    vector[offset++] = (value & 0x40) >>> 6 == 1;
                }
                case 6: {
                    vector[offset++] = (value & 0x20) >>> 5 == 1;
                }
                case 5: {
                    vector[offset++] = (value & 0x10) >>> 4 == 1;
                }
                case 4: {
                    vector[offset++] = (value & 8) >>> 3 == 1;
                }
                case 3: {
                    vector[offset++] = (value & 4) >>> 2 == 1;
                }
                case 2: {
                    vector[offset++] = (value & 2) >>> 1 == 1;
                }
                case 1: {
                    vector[offset++] = (value & 1) >>> 0 == 1;
                }
            }
            this.data = (byte)(this.data << count);
            this.bitsInData -= count;
            if (count == batchSize) {
                return countBitsSet;
            }
        }
        while (offset < batchSize - 7) {
            value = this.byteStream.next() & 0xFF;
            countBitsSet += Integer.bitCount(value);
            vector[offset + 0] = (value & 0x80) >>> 7 == 1;
            vector[offset + 1] = (value & 0x40) >>> 6 == 1;
            vector[offset + 2] = (value & 0x20) >>> 5 == 1;
            vector[offset + 3] = (value & 0x10) >>> 4 == 1;
            vector[offset + 4] = (value & 8) >>> 3 == 1;
            vector[offset + 5] = (value & 4) >>> 2 == 1;
            vector[offset + 6] = (value & 2) >>> 1 == 1;
            vector[offset + 7] = (value & 1) == 1;
            offset += 8;
        }
        int remaining = batchSize - offset;
        if (remaining > 0) {
            byte data = this.byteStream.next();
            int value2 = (data & 0xFF) >> 8 - remaining;
            countBitsSet += Integer.bitCount(value2);
            switch (remaining) {
                case 7: {
                    vector[offset++] = (value2 & 0x40) >>> 6 == 1;
                }
                case 6: {
                    vector[offset++] = (value2 & 0x20) >>> 5 == 1;
                }
                case 5: {
                    vector[offset++] = (value2 & 0x10) >>> 4 == 1;
                }
                case 4: {
                    vector[offset++] = (value2 & 8) >>> 3 == 1;
                }
                case 3: {
                    vector[offset++] = (value2 & 4) >>> 2 == 1;
                }
                case 2: {
                    vector[offset++] = (value2 & 2) >>> 1 == 1;
                }
                case 1: {
                    vector[offset++] = (value2 & 1) >>> 0 == 1;
                }
            }
            this.data = (byte)(data << remaining);
            this.bitsInData = 8 - remaining;
        }
        return countBitsSet;
    }

    public int getSetBits(int batchSize, boolean[] vector, boolean[] isNull) throws IOException {
        int count = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            vector[i] = this.nextBit();
            count += vector[i] ? 1 : 0;
        }
        return count;
    }

    public int getUnsetBits(int batchSize, boolean[] vector) throws IOException {
        int value;
        int unsetCount = 0;
        int offset = 0;
        int count = Math.min(batchSize, this.bitsInData);
        if (count != 0) {
            value = (this.data & 0xFF) >>> 8 - count;
            unsetCount += count - Integer.bitCount(value);
            switch (count) {
                case 7: {
                    vector[offset++] = (value & 0x40) == 0;
                }
                case 6: {
                    vector[offset++] = (value & 0x20) == 0;
                }
                case 5: {
                    vector[offset++] = (value & 0x10) == 0;
                }
                case 4: {
                    vector[offset++] = (value & 8) == 0;
                }
                case 3: {
                    vector[offset++] = (value & 4) == 0;
                }
                case 2: {
                    vector[offset++] = (value & 2) == 0;
                }
                case 1: {
                    vector[offset++] = (value & 1) == 0;
                }
            }
            this.data = (byte)(this.data << count);
            this.bitsInData -= count;
            if (count == batchSize) {
                return unsetCount;
            }
        }
        while (offset < batchSize - 7) {
            value = this.byteStream.next();
            unsetCount += 8 - Integer.bitCount(value & 0xFF);
            vector[offset + 0] = (value & 0x80) == 0;
            vector[offset + 1] = (value & 0x40) == 0;
            vector[offset + 2] = (value & 0x20) == 0;
            vector[offset + 3] = (value & 0x10) == 0;
            vector[offset + 4] = (value & 8) == 0;
            vector[offset + 5] = (value & 4) == 0;
            vector[offset + 6] = (value & 2) == 0;
            vector[offset + 7] = (value & 1) == 0;
            offset += 8;
        }
        int remaining = batchSize - offset;
        if (remaining > 0) {
            byte data = this.byteStream.next();
            int value2 = (data & 0xFF) >> 8 - remaining;
            unsetCount += remaining - Integer.bitCount(value2);
            switch (remaining) {
                case 7: {
                    vector[offset++] = (value2 & 0x40) == 0;
                }
                case 6: {
                    vector[offset++] = (value2 & 0x20) == 0;
                }
                case 5: {
                    vector[offset++] = (value2 & 0x10) == 0;
                }
                case 4: {
                    vector[offset++] = (value2 & 8) == 0;
                }
                case 3: {
                    vector[offset++] = (value2 & 4) == 0;
                }
                case 2: {
                    vector[offset++] = (value2 & 2) == 0;
                }
                case 1: {
                    vector[offset++] = (value2 & 1) == 0;
                }
            }
            this.data = (byte)(data << remaining);
            this.bitsInData = 8 - remaining;
        }
        return unsetCount;
    }

    public int getUnsetBits(int batchSize) throws IOException {
        int count = 0;
        for (int i = 0; i < batchSize; ++i) {
            count += this.nextBit() ? 0 : 1;
        }
        return count;
    }

    private static int bitCount(byte data) {
        return Integer.bitCount(data & 0xFF);
    }
}

