/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc.optimization;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.translator.FunctionTranslator;
import com.facebook.presto.expressions.translator.RowExpressionTranslator;
import com.facebook.presto.expressions.translator.RowExpressionTreeTranslator;
import com.facebook.presto.expressions.translator.TranslatedExpression;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableLayoutHandle;
import com.facebook.presto.plugin.jdbc.optimization.JdbcExpression;
import com.facebook.presto.plugin.jdbc.optimization.JdbcFilterToSqlTranslator;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JdbcComputePushdown
implements ConnectorPlanOptimizer {
    private final ExpressionOptimizer expressionOptimizer;
    private final JdbcFilterToSqlTranslator jdbcFilterToSqlTranslator;
    private final LogicalRowExpressions logicalRowExpressions;

    public JdbcComputePushdown(FunctionMetadataManager functionMetadataManager, StandardFunctionResolution functionResolution, DeterminismEvaluator determinismEvaluator, ExpressionOptimizer expressionOptimizer, String identifierQuote, Set<Class<?>> functionTranslators) {
        Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        Objects.requireNonNull(functionTranslators, "functionTranslators is null");
        Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
        Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.expressionOptimizer = Objects.requireNonNull(expressionOptimizer, "expressionOptimizer is null");
        this.jdbcFilterToSqlTranslator = new JdbcFilterToSqlTranslator(functionMetadataManager, (FunctionTranslator<JdbcExpression>)FunctionTranslator.buildFunctionTranslator(functionTranslators), identifierQuote);
        this.logicalRowExpressions = new LogicalRowExpressions(determinismEvaluator, functionResolution, functionMetadataManager);
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        return (PlanNode)maxSubplan.accept((PlanVisitor)new Visitor(session, idAllocator), null);
    }

    private class Visitor
    extends PlanVisitor<PlanNode, Void> {
        private final ConnectorSession session;
        private final PlanNodeIdAllocator idAllocator;

        public Visitor(ConnectorSession session, PlanNodeIdAllocator idAllocator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            ImmutableList.Builder children = ImmutableList.builder();
            boolean changed = false;
            for (PlanNode child : node.getSources()) {
                PlanNode newChild = (PlanNode)child.accept((PlanVisitor)this, null);
                if (newChild != child) {
                    changed = true;
                }
                children.add((Object)newChild);
            }
            if (!changed) {
                return node;
            }
            return node.replaceChildren((List)children.build());
        }

        public PlanNode visitFilter(FilterNode node, Void context) {
            if (!(node.getSource() instanceof TableScanNode)) {
                return node;
            }
            TableScanNode oldTableScanNode = (TableScanNode)node.getSource();
            TableHandle oldTableHandle = oldTableScanNode.getTable();
            JdbcTableHandle oldConnectorTable = (JdbcTableHandle)oldTableHandle.getConnectorHandle();
            RowExpression predicate = JdbcComputePushdown.this.expressionOptimizer.optimize(node.getPredicate(), ExpressionOptimizer.Level.OPTIMIZED, this.session);
            predicate = JdbcComputePushdown.this.logicalRowExpressions.convertToConjunctiveNormalForm(predicate);
            TranslatedExpression jdbcExpression = RowExpressionTreeTranslator.translateWith((RowExpression)predicate, (RowExpressionTranslator)JdbcComputePushdown.this.jdbcFilterToSqlTranslator, (Object)oldTableScanNode.getAssignments());
            if (!oldTableHandle.getLayout().isPresent() || !jdbcExpression.getTranslated().isPresent()) {
                return node;
            }
            JdbcTableLayoutHandle oldTableLayoutHandle = (JdbcTableLayoutHandle)oldTableHandle.getLayout().get();
            JdbcTableLayoutHandle newTableLayoutHandle = new JdbcTableLayoutHandle(this.session.getSqlFunctionProperties(), oldConnectorTable, oldTableLayoutHandle.getTupleDomain(), jdbcExpression.getTranslated());
            TableHandle tableHandle = new TableHandle(oldTableHandle.getConnectorId(), oldTableHandle.getConnectorHandle(), oldTableHandle.getTransaction(), Optional.of(newTableLayoutHandle));
            TableScanNode newTableScanNode = new TableScanNode(oldTableScanNode.getSourceLocation(), this.idAllocator.getNextId(), tableHandle, oldTableScanNode.getOutputVariables(), oldTableScanNode.getAssignments(), oldTableScanNode.getCurrentConstraint(), oldTableScanNode.getEnforcedConstraint());
            return new FilterNode(node.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)newTableScanNode, node.getPredicate());
        }
    }
}

