/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;

public class HistoryTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private static final List<ColumnMetadata> COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("made_current_at", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)).add((Object)new ColumnMetadata("snapshot_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("parent_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("is_current_ancestor", (Type)BooleanType.BOOLEAN)).build();

    public HistoryTable(SchemaTableName tableName, Table icebergTable) {
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), COLUMNS);
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder(COLUMNS);
        ImmutableSet ancestorIds = ImmutableSet.copyOf((Collection)SnapshotUtil.currentAncestorIds((Table)this.icebergTable));
        for (HistoryEntry historyEntry : this.icebergTable.history()) {
            long snapshotId = historyEntry.snapshotId();
            Snapshot snapshot = this.icebergTable.snapshot(snapshotId);
            table.addRow(new Object[]{DateTimeEncoding.packDateTimeWithZone((long)historyEntry.timestampMillis(), (TimeZoneKey)session.getSqlFunctionProperties().getTimeZoneKey()), snapshotId, snapshot != null ? snapshot.parentId() : null, ancestorIds.contains(snapshotId)});
        }
        return table.build().cursor();
    }
}

